package com.jiejing.fitness.finance.service.pay;

import com.jiejing.fitness.finance.service.pay.params.NativePayParams;
import com.jiejing.fitness.finance.service.pay.params.StudioMerchantPayParams;
import com.jiejing.fitness.finance.service.pay.params.BrandMerchantRefundParams;
import com.jiejing.paycenter.common.enums.common.PayChannelEnums;
import com.jiejing.paycenter.common.model.vo.PayVO;
import com.jiejing.paycenter.api.pay.vo.RefundVO;
import com.jiejing.paycenter.common.event.PayEvent;
import com.jiejing.paycenter.common.event.RefundEvent;
import java.util.Date;

/**
 * @author chengyubing
 * @since 2024/2/27 11:05
 */
public interface PayService {

  /**
   * 获取openId
   *
   * @param channel  渠道
   * @param appId    appId
   * @param authCode 标记
   * @return openId
   */
  String getOpenId(PayChannelEnums channel, String appId, String authCode);

  /**
   * Native支付
   *
   * @param params 参数
   * @return 结果
   */
  PayVO nativePay(NativePayParams params);

  /**
   * 支付
   *
   * @param params 请求参数
   * @return 结果
   */
  PayVO merchantPay(StudioMerchantPayParams params);

  /**
   * 支付回调
   *
   * @param event 事件
   */
  void payCallback(PayEvent event);

  /**
   * 商户退款
   *
   * @param params 参数
   * @return 结果
   */
  RefundVO merchantRefund(BrandMerchantRefundParams params);

  /**
   * 退款回调
   *
   * @param event 事件
   */
  void refundCallback(RefundEvent event);

  /**
   * 对账
   *
   * @param merchantId 商户ID
   * @param settleDate 结算日
   */
  void checkSettle(Long merchantId, Date settleDate);

  /**
   * 同步结算状态
   *
   * @param merchantId 商户ID
   * @param settleDate 结算日
   */
  void syncSettle(Long merchantId, Date settleDate);

}
