package com.jiejing.fitness.finance.api.cashier.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/4/8 17:14
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "场馆收银流水统计VO")
public class StudioCashierStatisticVO {

  @ApiModelProperty("总交易金额（元）")
  private BigDecimal totalTransAmount;

  @ApiModelProperty("总实际金额（元）")
  private BigDecimal totalActualAmount;

  @ApiModelProperty("总条数")
  private Long total;

}
