package com.jiejing.fitness.finance.service.rpc;

import com.google.common.collect.Lists;
import com.jiejing.common.model.JsonResult;
import com.jiejing.configcenter.ConfigRpcService;
import com.jiejing.configcenter.api.config.request.GetConfigDetailsRequest;
import com.jiejing.configcenter.api.config.vo.DetailVO;
import com.jiejing.fitness.enums.config.ObjectTypeEnum;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author chengyubing
 * @since 2024/6/15 17:20
 */
@Slf4j
@Service
public class FitConfigService {

  @Resource
  private ConfigRpcService configRpcService;

  public List<DetailVO> listConfig(ObjectTypeEnum objectType, Long objectId, List<String> codes) {
    return configRpcService.getConfigDetails(String.valueOf(objectId), objectType.getCode(), codes);
  }

  public DetailVO getConfig(ObjectTypeEnum objectType, Long objectId, String code) {
    return this.listConfig(objectType, objectId, Lists.newArrayList(code)).stream().findFirst().orElse(null);
  }

  public Boolean getStudioBoolConfig(Long objectId, String code) {
    DetailVO vo = getConfig(ObjectTypeEnum.STUDIO, objectId, code);
    return Boolean.parseBoolean(vo.getConfigValue());
  }

}
