package com.jiejing.fitness.finance.service.cashier.convert;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.jiejing.common.model.PageVO;
import com.jiejing.common.utils.collection.CollectionUtil;
import com.jiejing.common.utils.convert.BeanUtil;
import com.jiejing.common.utils.crypt.AesUtil;
import com.jiejing.common.utils.text.SensitiveUtil;
import com.jiejing.fitness.finance.api.cashier.vo.StudioCashierRecordVO;
import com.jiejing.fitness.finance.api.cashier.vo.StudioSettleVO;
import com.jiejing.fitness.finance.repository.entity.StudioCashierRecord;
import com.jiejing.fitness.finance.repository.entity.StudioSettleRecord;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;

/**
 * @author chengyubing
 * @since 2024/2/29 11:09
 */
public class CashierConvert {

  public static StudioCashierRecordVO convertVO(StudioCashierRecord record) {
    StudioCashierRecordVO result = new StudioCashierRecordVO();
    BeanUtils.copyProperties(record, result, "extra");
    result.setExtra(JSON.parseObject(Optional.ofNullable(record.getExtra()).orElse("{}")));
    return result;
  }

  public static List<StudioCashierRecordVO> convertList(List<StudioCashierRecord> list) {
    if (CollectionUtil.isEmpty(list)) {
      return Lists.newArrayList();
    }
    return list.stream().map(CashierConvert::convertVO).collect(Collectors.toList());
  }

  public static PageVO<StudioCashierRecordVO> convertPageVO(Page<StudioCashierRecord> page) {
    return PageVO.convert(page, convertList(page.getContent()));
  }

  public static PageVO<StudioSettleVO> convertSettlePageVO(Page<StudioSettleRecord> page) {
    return PageVO.convert(page, convertSettleList(page.getContent()));
  }

  private static List<StudioSettleVO> convertSettleList(List<StudioSettleRecord> list) {
    if (CollectionUtil.isEmpty(list)) {
      return Lists.newArrayList();
    }
    return list.stream().map(e -> {
      StudioSettleVO vo = CashierConvert.convertSettleVO(e);
      vo.setCardNo(SensitiveUtil.bankCard(AesUtil.decrypt(e.getSalt(), e.getCardNo())));
      return vo;
    }).collect(Collectors.toList());
  }

  public static StudioSettleVO convertSettleVO(StudioSettleRecord record) {
    StudioSettleVO vo = BeanUtil.map(record, StudioSettleVO.class);
    vo.setCardNo(AesUtil.decrypt(record.getSalt(), record.getCardNo()));
    return vo;
  }
}
