package com.jiejing.fitness.finance.service.pay;

import com.jiejing.fitness.finance.api.merchant.vo.StudioMerchantCheckRefundVO;
import com.jiejing.fitness.finance.api.merchant.vo.StudioMerchantRefundVO;
import com.jiejing.fitness.finance.service.pay.params.StudioMerchantRefundParams;
import com.jiejing.paycenter.common.event.RefundEvent;
import com.jiejing.paycenter.common.model.vo.RefundVO;

/**
 * @author chengyubing
 * @since 2024/5/7 16:37
 */
public interface RefundService {

  /**
   * 退款前检查
   *
   * @param params 参数
   * @return 结果
   */
  StudioMerchantCheckRefundVO checkBeforeMerchantRefund(StudioMerchantRefundParams params);

  /**
   * 商户退款
   *
   * @param params 参数
   * @return 结果
   */
  StudioMerchantRefundVO merchantRefund(StudioMerchantRefundParams params);

  /**
   * 退款回调
   *
   * @param event 事件
   */
  void refundCallback(RefundEvent event);

}
