package com.jiejing.fitness.finance.service.pay.params;

import com.alibaba.fastjson.JSONObject;
import com.jiejing.fitness.enums.finance.PayOrderTypeEnum;
import com.jiejing.paycenter.common.enums.common.PayChannelEnums;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/4/11 13:58
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "App支付请求")
public class AppPayParams {

  @ApiModelProperty(name = "业务订单号", required = true)
  @NotBlank(message = "业务订单号不能为空")
  private String orderNo;

  @ApiModelProperty(name = "支付渠道", required = true)
  @NotNull(message = "支付渠道不能为空")
  private PayChannelEnums channel;

  @ApiModelProperty(name = "业务订单类型", required = true)
  @NotNull(message = "业务订单类型不能为空")
  private PayOrderTypeEnum orderType;

  @ApiModelProperty(name = "商品名称", required = true)
  @NotBlank(message = "商品名称不能为空")
  private String goods;

  @ApiModelProperty(name = "支付总金额（元）", required = true)
  @NotNull(message = "支付总金额不能为空")
  private BigDecimal amount;

  @ApiModelProperty(name = "过期时间（单位：秒）", required = true)
  @NotNull(message = "过期时间不能为空")
  @Min(value = 60, message = "过期时间最低60秒")
  private Integer timeExpire;

  @ApiModelProperty(name = "业务扩展信息", required = true)
  @NotNull(message = "业务参扩展信息不能为空")
  private JSONObject extra;

}