package com.jiejing.fitness.finance.api.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import java.util.Arrays;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 商户类型
 *
 * @author raccoon
 * @since 2020-11-06 16:44
 */
@Getter
@AllArgsConstructor
public enum MerchantTypeEnums {

  /**
   * 未知
   */
  UNKNOWN("", ""),
  BRAND("BRAND", "品牌"),
  STUDIO("STUDIO", "场馆"),

  ;

  @EnumValue
  private final String code;

  private final String desc;

  public static MerchantTypeEnums getByCode(String code) {
    return Arrays.stream(MerchantTypeEnums.values()).filter(e -> e.getCode().equals(code)).findFirst()
        .orElse(UNKNOWN);
  }

}
