package com.jiejing.fitness.finance.service.merchant.convert;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.jiejing.common.utils.crypt.AesUtil;
import com.jiejing.filecenter.api.resource.vo.ResourceInfoVO;
import com.jiejing.fitness.finance.api.enums.ApplyTypeEnums;
import com.jiejing.fitness.finance.repository.entity.BrandMerchantApply;
import com.jiejing.fitness.finance.service.merchant.params.ApplyBrandMerchantParams;
import com.jiejing.paycenter.api.merchant.request.ApplyMerchantRequest;
import com.jiejing.paycenter.api.merchant.request.UploadRequest;
import com.jiejing.paycenter.common.enums.common.OpenStateEnums;
import com.jiejing.paycenter.common.enums.merchant.BusinessTypeEnums;
import com.jiejing.paycenter.common.enums.merchant.LicenseTypeEnums;
import com.jiejing.paycenter.common.enums.merchant.MccEnums;
import com.jiejing.paycenter.common.enums.merchant.PaySceneEnums;
import com.jiejing.paycenter.common.enums.merchant.ResourceTypeEnums;
import com.jiejing.paycenter.common.enums.merchant.SceneTypeEnums;
import com.jiejing.paycenter.common.model.Address;
import com.jiejing.paycenter.common.model.BankCard;
import com.jiejing.paycenter.common.model.BusinessInfo;
import com.jiejing.paycenter.common.model.Contact;
import com.jiejing.paycenter.common.model.Legal;
import com.jiejing.paycenter.common.model.License;
import com.jiejing.paycenter.common.model.SubChannelInfo;
import com.jiejing.studio.api.studio.vo.StudioVO;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author chengyubing
 * @since 2024/2/20 16:46
 */
public class MerchantConvert {

  private final static BigDecimal ALI_OFFLINE_FEE_RATE = new BigDecimal("0.38");

  private final static BigDecimal WX_OFFLINE_FEE_RATE = new BigDecimal("0.38");

  private final static List<SubChannelInfo> DEFAULT_SUB_CHANNELS = Lists.newArrayList(
      SubChannelInfo.builder().scene(PaySceneEnums.ALI_OFFLINE).feeRate(ALI_OFFLINE_FEE_RATE).build(),
      SubChannelInfo.builder().scene(PaySceneEnums.WX_OFFLINE_OFFICIAL).feeRate(WX_OFFLINE_FEE_RATE).build(),
      SubChannelInfo.builder().scene(PaySceneEnums.WX_OFFLINE_MINI).feeRate(WX_OFFLINE_FEE_RATE).build()
  );

  public static ApplyMerchantRequest convertRequest(String channelNo, String applyNo, Long partyId,
      ApplyBrandMerchantParams params) {
    return ApplyMerchantRequest.builder()
        .applyNo(applyNo)
        .channelNo(channelNo)
        .companyType(params.getCompanyType())
        .merchantName(params.getMerchantName())
        .shortName(params.getShortName())
        .legal(convertLegal(params))
        .bankCard(convertBankCard(params))
        .license(convertLicense(params))
        .business(convertBusiness(params))
        .contact(convertContact(params))
        .subChannels(DEFAULT_SUB_CHANNELS)
        .resourceMap(params.getResourceInfo())
        .build();
  }


  private static Contact convertContact(ApplyBrandMerchantParams params) {
    return Contact.builder()
        .contactName(params.getLegalName())
        .contactPhone(params.getLegalPhone())
        .contactEmail(params.getContactEmail())
        .servicePhone(params.getLegalPhone())
        .build();
  }

  private static BusinessInfo convertBusiness(ApplyBrandMerchantParams params) {
    return BusinessInfo.builder()
        .mcc(MccEnums.MCC_7941)
        .businessType(BusinessTypeEnums.REALITY)
        .sceneType(SceneTypeEnums.OFFLINE)
        .businessAddress(Address.builder()
            .province(params.getBusinessProvince())
            .city(params.getBusinessCity())
            .district(params.getBusinessDistrict())
            .address(params.getBusinessAddress())
            .build())
        .build();
  }

  private static License convertLicense(ApplyBrandMerchantParams params) {
    return License.builder()
        .licenseCode(params.getLicenseCode())
        .licenseType(LicenseTypeEnums.NATIONAL_LEGAL_MERGE)
        .licenseExpireType(params.getLicenseExpireType())
        .licenseStartDate(params.getLicenseStartDate())
        .licenseEndDate(params.getLicenseEndDate())
        .businessScope(params.getLicenseBusinessScope())
        .foundDate(params.getLicenseFoundDate())
        .registeredCapital("10000")
        .licenseAddress(Address.builder()
            .province(params.getLicenseProvince())
            .city(params.getLicenseCity())
            .district(params.getLicenseDistrict())
            .address(params.getLicenseAddress())
            .build())
        .build();
  }

  private static BankCard convertBankCard(ApplyBrandMerchantParams params) {
    return BankCard.builder()
        .cardType(params.getBankCardType())
        .cardNo(params.getBankCardNo())
        .cardName(params.getBankCardName())
        .phone(params.getBankPhone())
        .certNo(params.getBankCertNo())
        .certType(params.getBankCertType())
        .baseDepositNo(params.getBankBaseDepositNo())
        .certExpireType(params.getBankCertExpireType())
        .certStartDate(params.getBankCertStartDate())
        .certEndDate(params.getBankCertEndDate())
        .bankCode(params.getBankCode())
        .bankName(params.getBankName())
        .branchName(params.getBankBranchName())
        .branchCode(params.getBankBranchCode())
        .cardAddress(Address.builder()
            .province(params.getBankCardProvince())
            .city(params.getBankCardCity())
            .district(params.getBankCardDistrict())
            .address(params.getBankCardAddress())
            .build())
        .build();
  }

  private static Legal convertLegal(ApplyBrandMerchantParams params) {
    return Legal.builder()
        .legalName(params.getLegalName())
        .legalPhone(params.getLegalPhone())
        .legalCertNo(params.getLegalCertNo())
        .legalCertType(params.getLegalCertType())
        .legalCertExpireType(params.getLegalCertExpireType())
        .legalCertStartDate(params.getLegalCertStartDate())
        .legalCertEndDate(params.getLegalCertEndDate())
        .legalAddress(Address.builder()
            .province(params.getLegalProvince())
            .city(params.getLegalCity())
            .district(params.getLegalDistrict())
            .address(params.getLegalAddress())
            .build())
        .build();
  }

  public static BrandMerchantApply convertApply(Long id, ApplyBrandMerchantParams params, StudioVO studio,
      BrandMerchantApply exist, String channel) {
    String salt = AesUtil.getSalt(8);
    ApplyBrandMerchantParams encrypt = params.encrypt(salt);
    return BrandMerchantApply.builder()
        .id(id)
        .applyNo(Long.toString(id))
        .brandId(studio.getBrandId())
        .studioId(encrypt.getStudioId())
        .applyType(exist == null ? ApplyTypeEnums.OPEN : ApplyTypeEnums.RE_OPEN)
        .channelNo(channel)
        .merchantName(encrypt.getMerchantName())
        .shortName(encrypt.getShortName())
        .companyType(encrypt.getCompanyType())
        .openState(OpenStateEnums.INIT)
        .businessProvince(encrypt.getBusinessProvince())
        .businessCity(encrypt.getBusinessCity())
        .businessDistrict(encrypt.getBusinessDistrict())
        .businessAddress(encrypt.getBusinessAddress())
        .licenseCode(encrypt.getLicenseCode())
        .licenseExpireType(encrypt.getLicenseExpireType())
        .licenseStartDate(encrypt.getLicenseStartDate())
        .licenseEndDate(encrypt.getLicenseEndDate())
        .licenseBusinessScope(encrypt.getLicenseBusinessScope())
        .licenseFoundDate(encrypt.getLicenseFoundDate())
        .licenseProvince(encrypt.getLicenseProvince())
        .licenseCity(encrypt.getLicenseCity())
        .licenseDistrict(encrypt.getLicenseDistrict())
        .licenseAddress(encrypt.getLicenseAddress())
        .legalName(encrypt.getLegalName())
        .legalCertNo(encrypt.getLegalCertNo())
        .legalCertType(encrypt.getLegalCertType())
        .legalCertExpireType(encrypt.getLegalCertExpireType())
        .legalCertStartDate(encrypt.getLegalCertStartDate())
        .legalCertEndDate(encrypt.getLegalCertEndDate())
        .legalPhone(encrypt.getLegalPhone())
        .legalProvince(encrypt.getLegalProvince())
        .legalCity(encrypt.getLegalCity())
        .legalDistrict(encrypt.getLegalDistrict())
        .legalAddress(encrypt.getLegalAddress())
        .contactEmail(encrypt.getContactEmail())
        .bankCardType(encrypt.getBankCardType())
        .bankCardNo(encrypt.getBankCardNo())
        .bankCardName(encrypt.getBankCardName())
        .bankPhone(encrypt.getBankPhone())
        .bankCertNo(encrypt.getBankCertNo())
        .bankCertType(encrypt.getBankCertType())
        .bankCertExpireType(encrypt.getBankCertExpireType())
        .bankCertStartDate(encrypt.getBankCertStartDate())
        .bankCertEndDate(encrypt.getBankCertEndDate())
        .bankBaseDepositNo(encrypt.getBankBaseDepositNo())
        .bankCode(encrypt.getBankCode())
        .bankName(encrypt.getBankName())
        .bankBranchName(encrypt.getBankBranchName())
        .bankBranchCode(encrypt.getBankBranchCode())
        .bankCardProvince(encrypt.getBankCardProvince())
        .bankCardCity(encrypt.getBankCardCity())
        .bankCardDistrict(encrypt.getBankCardDistrict())
        .bankCardAddress(encrypt.getBankCardAddress())
        .resourceInfo(JSON.toJSONString(encrypt.getResourceInfo()))
        .salt(salt)
        .createTime(new Date())
        .updateTime(new Date())
        .build();
  }

  public static UploadRequest convertUploadRequest(String channel, ResourceTypeEnums type,
      ResourceInfoVO vo) {
    return UploadRequest.builder()
        .url(vo.getUrl())
        .fileSize(vo.getFileSize())
        .suffix(vo.getSuffix())
        .channelNo(channel)
        .resourceType(type)
        .build();
  }

}
