package com.jiejing.fitness.finance.service.merchant.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jiejing.filecenter.api.resource.vo.ResourceInfoVO;
import com.jiejing.fitness.finance.repository.entity.BrandMerchantApply;
import com.jiejing.fitness.finance.repository.service.BrandMerchantApplyRpService;
import com.jiejing.fitness.finance.service.merchant.BrandMerchantService;
import com.jiejing.fitness.finance.service.merchant.convert.MerchantConvert;
import com.jiejing.fitness.finance.service.merchant.params.ApplyBrandMerchantParams;
import com.jiejing.fitness.finance.service.rpc.MerchantRpcService;
import com.jiejing.fitness.finance.service.rpc.ResourceRpcService;
import com.jiejing.fitness.finance.service.rpc.StudioRpcService;
import com.jiejing.paycenter.common.enums.common.OpenStateEnums;
import com.jiejing.paycenter.common.model.ResourceInfo;
import com.jiejing.studio.api.studio.vo.StudioVO;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

/**
 * 品牌商户服务
 *
 * @author chengyubing
 * @since 2024/2/20 14:01
 */
@Slf4j
@Service
public class BrandMerchantServiceImpl implements BrandMerchantService {

  @Value("${finance.brand.merchant.channel}")
  private String channel;

  @Resource
  private StudioRpcService studioRpcService;

  @Resource
  private MerchantRpcService merchantRpcService;

  @Resource
  private ResourceRpcService resourceRpcService;

  @Resource
  private BrandMerchantApplyRpService brandMerchantApplyRpService;

  @Async(value = "financeThreadPool")
  @Override
  public void apply(ApplyBrandMerchantParams params) {

    Long id = IdWorker.getId();
    StudioVO studio = studioRpcService.getStudio(params.getStudioId());
    BrandMerchantApply exist = brandMerchantApplyRpService.getLatestOneSuccessByBrandId(
        studio.getBrandId());
    BrandMerchantApply apply = MerchantConvert.convertApply(id, params, studio, exist, channel);

    brandMerchantApplyRpService.insert(apply);

    try {

      this.upload(params);
      merchantRpcService.apply(MerchantConvert.convertRequest(channel, apply.getApplyNo(),
          studio.getBrandId(), params));

    } catch (Exception e) {
      brandMerchantApplyRpService.updateById(
          BrandMerchantApply.builder().id(id).openState(OpenStateEnums.FAIL)
              .openFailMessage(e.getMessage()).build());
    }

  }

  private void upload(ApplyBrandMerchantParams params) {

    Map<Long, ResourceInfoVO> resourceIdUrlMap = resourceRpcService.getResourceMap(params.getStudioId(),
        getResourceIds(params));

    params.getResourceInfo().keySet().forEach(type -> {
      ResourceInfo info = params.getResourceInfo().get(type);
      ResourceInfoVO vo = resourceIdUrlMap.get(info.getResourceId());
      String thirdId = merchantRpcService.upload(MerchantConvert.convertUploadRequest(channel, type, vo));
      info.setThirdId(thirdId);
    });

  }

  private List<Long> getResourceIds(ApplyBrandMerchantParams params) {
    return params.getResourceInfo().values().stream()
        .map(ResourceInfo::getResourceId)
        .filter(Objects::nonNull)
        .distinct()
        .collect(Collectors.toList());
  }

}
