package com.jiejing.fitness.finance.service.pay.params;

import com.alibaba.fastjson.JSONObject;
import com.jiejing.fitness.enums.finance.PayOrderTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/2/27 10:54
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "场馆商户退款Params")
public class StudioMerchantRefundParams {

  @ApiModelProperty(value = "场馆ID", required = true)
  @NotNull(message = "场馆ID不能为空")
  private Long studioId;

  @ApiModelProperty(name = "订单类型", required = true)
  @NotNull(message = "订单类型不能为空")
  private PayOrderTypeEnum orderType;

  @ApiModelProperty(name = "退款总金额（元）", required = true)
  @NotNull(message = "退款总金额不能为空")
  private BigDecimal transAmount;

  @ApiModelProperty(name = "退款请求对应的支付流水号", required = true)
  @NotBlank(message = "退款请求对应的支付流水号不能为空")
  private String payTransNo;

  @ApiModelProperty(name = "退款原因", required = true)
  @NotBlank(message = "退款原因不能为空")
  private String refundReason;

  @ApiModelProperty(name = "上层业务退款ID")
  private String orderNo;

  @ApiModelProperty(name = "上层业务退款订单号")
  private String businessNo;

  @ApiModelProperty(name = "上层业务子订单号")
  private String subOrderNo;

  @ApiModelProperty(name = "业务扩展信息")
  private JSONObject extra;

}
