package com.jiejing.fitness.finance.service.bank.impl;

import com.jiejing.common.model.PageVO;
import com.jiejing.common.utils.convert.BeanUtil;
import com.jiejing.fitness.finance.repository.entity.Bank;
import com.jiejing.fitness.finance.repository.entity.BranchBank;
import com.jiejing.fitness.finance.repository.service.BankRpService;
import com.jiejing.fitness.finance.repository.service.BranchBankRpService;
import com.jiejing.fitness.finance.service.bank.BankService;
import com.jiejing.fitness.finance.service.bank.dto.BankDTO;
import com.jiejing.fitness.finance.service.bank.dto.BranchBankDTO;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

/**
 * @author chengyubing
 * @since 2024/4/1 14:21
 */
@Slf4j
@Service
public class BankServiceImpl implements BankService {

  @Resource
  private BankRpService bankRpService;

  @Resource
  private BranchBankRpService branchBankRpService;

  @Override
  public PageVO<BankDTO> pageBank(String bankName, Integer current, Integer size) {
    Page<Bank> page = bankRpService.page(bankName, current, size);
    if (page.isEmpty()) {
      return PageVO.empty(current, size);
    }
    return PageVO.convert(page, BeanUtil.mapList(page.getContent(), BankDTO.class));
  }

  @Override
  public PageVO<BranchBankDTO> pageBranchBank(String bankCode, String branchName, Integer current,
      Integer size) {
    Page<BranchBank> page = branchBankRpService.page(bankCode, branchName, current, size);
    if (page.isEmpty()) {
      return PageVO.empty(current, size);
    }
    return PageVO.convert(page, BeanUtil.mapList(page.getContent(), BranchBankDTO.class));
  }
}
