package com.jiejing.fitness.finance.api.merchant.request;

import com.jiejing.fitness.finance.api.enums.ApplyTypeEnums;
import com.jiejing.paycenter.common.enums.common.OpenStateEnums;
import com.jiejing.paycenter.common.enums.merchant.CompanyTypeEnums;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/2/22 16:38
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "分页查询申请场馆商户请求信息Request")
public class PageStudioMerchantApplyRequest {

  @ApiModelProperty(value = "商户简称")
  private String shortName;

  @ApiModelProperty(value = "操作类型")
  private ApplyTypeEnums applyType;

  @ApiModelProperty(value = "场馆ID")
  private Long studioId;

  @ApiModelProperty(value = "申请类型")
  private CompanyTypeEnums companyType;

  @ApiModelProperty(value = "商户名称")
  private String merchantName;

  @ApiModelProperty(value = "申请状态")
  private OpenStateEnums openState;

  @ApiModelProperty(value = "商户号")
  private String merchantNo;

  @ApiModelProperty(value = "支付宝商户号")
  private String aliMerchantNo;

  @ApiModelProperty(value = "微信线上商户号")
  private String wxOnlineMerchantNo;

  @ApiModelProperty(value = "微信线下商户号")
  private String wxOfflineMerchantNo;

  @ApiModelProperty(value = "页码：0开始", required = true)
  @NotNull(message = "页码不能为空")
  private Integer current;

  @ApiModelProperty(value = "分页大小", required = true)
  @NotNull(message = "分页大小不能为空")
  private Integer size;

}
