package com.jiejing.fitness.finance.api.merchant;

import com.jiejing.common.model.JsonResult;
import com.jiejing.fitness.finance.api.merchant.request.ApplyBrandMerchantRequest;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * 品牌商户API
 *
 * @author chengyubing
 * @since 2024/2/22 11:49
 */
@FeignClient(name = "PAYCENTER", url = "http://app-paycenter:7007", fallbackFactory = BrandMerchantApi.class)
public interface BrandMerchantApi {

  String TAG = "金融-品牌商户管理";

  @ApiOperation(value = "品牌入驻商户", tags = {TAG})
  @PostMapping(value = "/private/brandMerchant/apply")
  JsonResult<Void> apply(ApplyBrandMerchantRequest request);

}
