/*
 * Copyright © 2024 Hangzhou Jiejing Technology Co., Ltd. All rights reserved.
 *
 * The copyright of the company's program code belongs to Hangzhou Jiejing Technology Co., Ltd. No one can illegally copy it without the explicit permission of this website.
 * Official website: www.xiaomai5.com
 *
 *
 *
 * Copyright © 2024 杭州杰竞科技有限公司 版权所有.
 *
 * 本公司程序代码的版权归杭州杰竞科技有限公司所有，未经本网站的明确许可，任何人不得非法复制。
 * 官网: www.xiaomai5.com
 */

package com.jiejing.fitness.finance.repository.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.jiejing.paycenter.common.enums.common.OpenStateEnums;
import com.jiejing.paycenter.common.enums.merchant.CardTypeEnums;
import com.jiejing.paycenter.common.enums.merchant.CertTypeEnums;
import com.jiejing.paycenter.common.enums.merchant.CompanyTypeEnums;
import com.jiejing.paycenter.common.enums.merchant.ExpireTypeEnums;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * <p>
 * 品牌商户表（只保留最新在用的）
 * </p>
 *
 * @author chengyubing, created on 2024-02-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Builder(toBuilder = true)
@NoArgsConstructor
@AllArgsConstructor
public class BrandMerchant implements Serializable {

  private static final long serialVersionUID = 8098172448095897767L;

  /**
   * 备注: ID 是否允许为null: NO
   */
  @TableId(value = "id", type = IdType.ID_WORKER)
  private Long id;

  /**
   * 备注: 品牌ID 是否允许为null: YES
   */
  private Long brandId;

  /**
   * 备注: 渠道号 是否允许为null: YES
   */
  private String channelNo;

  /**
   * 备注: paycenter的商户ID 是否允许为null: YES
   */
  private Long merchantId;

  /**
   * 备注: 三方商户号 是否允许为null: YES
   */
  private String merchantNo;

  /**
   * 备注: 商户名称 是否允许为null: YES
   */
  private String merchantName;

  /**
   * 备注: 商户简称 是否允许为null: YES
   */
  private String shortName;

  /**
   * 备注: 企业类型 是否允许为null: YES
   */
  private CompanyTypeEnums companyType;

  /**
   * 备注: 支付宝认证状态 默认值: I 是否允许为null: YES
   */
  private OpenStateEnums aliAuthState;

  /**
   * 备注: 支付宝商户号 是否允许为null: YES
   */
  private String aliMerchantNo;

  /**
   * 备注: 微信线下通道认证状态：I-初始态；S-成功；F-失败 默认值: I 是否允许为null: YES
   */
  private OpenStateEnums wxOfflineAuthState;

  /**
   * 备注: 微信线下通道商户号 是否允许为null: YES
   */
  private String wxOfflineMerchantNo;

  /**
   * 备注: 微信线上通道认证状态：I-初始态；S-成功；F-失败 默认值: I 是否允许为null: YES
   */
  private OpenStateEnums wxOnlineAuthState;

  /**
   * 备注: 微信线上通道商户号 是否允许为null: YES
   */
  private String wxOnlineMerchantNo;

  /**
   * 备注: 经营地址：省 是否允许为null: YES
   */
  private String businessProvince;

  /**
   * 备注: 经营地址：市 是否允许为null: YES
   */
  private String businessCity;

  /**
   * 备注: 经营地址：区 是否允许为null: YES
   */
  private String businessDistrict;

  /**
   * 备注: 商户经营详细地址 是否允许为null: YES
   */
  private String businessAddress;

  /**
   * 备注: 营业执照号 是否允许为null: YES
   */
  private String licenseCode;

  /**
   * 备注: 营业执照有效期类型 是否允许为null: YES
   */
  private ExpireTypeEnums licenseExpireType;

  /**
   * 备注: 营业执照有效期开始日期 是否允许为null: YES
   */
  private Date licenseStartDate;

  /**
   * 备注: 营业执照有效期截止日期 是否允许为null: YES
   */
  private Date licenseEndDate;

  /**
   * 备注: 营业护照规定的经营范围 是否允许为null: YES
   */
  private String licenseBusinessScope;

  /**
   * 备注: 营业执照创办日期 是否允许为null: YES
   */
  private Date licenseFoundDate;

  /**
   * 备注: 注册资本 是否允许为null: YES
   */
  private String licenseRegisteredCapital;

  /**
   * 备注: 商户经营地址：省 是否允许为null: YES
   */
  private String licenseProvince;

  /**
   * 备注: 商户经营地址：市 是否允许为null: YES
   */
  private String licenseCity;

  /**
   * 备注: 商户经营地址：区 是否允许为null: YES
   */
  private String licenseDistrict;

  /**
   * 备注: 营业执照注册详细地址 是否允许为null: NO
   */
  private String licenseAddress;

  /**
   * 备注: 法人姓名 是否允许为null: YES
   */
  private String legalName;

  /**
   * 备注: 法人证件号码 是否允许为null: YES
   */
  private String legalCertNo;

  /**
   * 备注: 法人证件类型 是否允许为null: YES
   */
  private CertTypeEnums legalCertType;

  /**
   * 备注: 法人证件有效期类型 是否允许为null: YES
   */
  private ExpireTypeEnums legalCertExpireType;

  /**
   * 备注: 法人证件有效期开始日期 是否允许为null: YES
   */
  private Date legalCertStartDate;

  /**
   * 备注: 法人证件有效期截止日期 是否允许为null: YES
   */
  private Date legalCertEndDate;

  /**
   * 备注: 法人手机号 是否允许为null: YES
   */
  private String legalPhone;

  /**
   * 备注: 法人证件地址：省 是否允许为null: YES
   */
  private String legalProvince;

  /**
   * 备注: 法人证件地址：市 是否允许为null: YES
   */
  private String legalCity;

  /**
   * 备注: 法人证件地址：区 是否允许为null: YES
   */
  private String legalDistrict;

  /**
   * 备注: 法人证件详细地址 是否允许为null: YES
   */
  private String legalAddress;

  /**
   * 备注: 联系人邮箱 是否允许为null: YES
   */
  private String contactEmail;

  /**
   * 备注: 结算卡类型：对公卡、对私卡 是否允许为null: YES
   */
  private CardTypeEnums bankCardType;

  /**
   * 备注: 结算卡卡号 是否允许为null: YES
   */
  private String bankCardNo;

  /**
   * 备注: 银行卡账户名（对私卡：持卡人姓名；对公卡：营业执照名称） 是否允许为null: YES
   */
  private String bankCardName;

  /**
   * 备注: 持卡人手机号（对私卡必填） 是否允许为null: YES
   */
  private String bankPhone;

  /**
   * 备注: 结算卡证件号码（对私卡：持卡人身份证；对公卡：营业执照号） 是否允许为null: YES
   */
  private String bankCertNo;

  /**
   * 备注: 结算卡持卡人证件类型 是否允许为null: YES
   */
  private CertTypeEnums bankCertType;

  /**
   * 备注: 证件有效期类型，对私卡必填 是否允许为null: YES
   */
  private ExpireTypeEnums bankCertExpireType;

  /**
   * 备注: 持卡人证件有效期开始日期，对私卡必填 是否允许为null: YES
   */
  private Date bankCertStartDate;

  /**
   * 备注: 持卡人证件有效期截止日期 是否允许为null: YES
   */
  private Date bankCertEndDate;

  /**
   * 备注: 基本存款账户编号 是否允许为null: YES
   */
  private String bankBaseDepositNo;

  /**
   * 备注: 银行编码 是否允许为null: YES
   */
  private String bankCode;

  /**
   * 备注: bankName 是否允许为null: YES
   */
  private String bankName;

  /**
   * 备注: 支行名称 是否允许为null: YES
   */
  private String bankBranchName;

  /**
   * 备注: 支行号 是否允许为null: YES
   */
  private String bankBranchCode;

  /**
   * 备注: 结算卡开卡地址：省 是否允许为null: YES
   */
  private String bankCardProvince;

  /**
   * 备注: 结算卡开卡地址：市 是否允许为null: YES
   */
  private String bankCardCity;

  /**
   * 备注: 结算卡开卡地址：区 是否允许为null: YES
   */
  private String bankCardDistrict;

  /**
   * 备注: 结算卡开卡详细地址 是否允许为null: YES
   */
  private String bankCardAddress;

  /**
   * 备注: 资源信息 是否允许为null: YES
   */
  private String resourceInfo;

  /**
   * 备注: 盐 是否允许为null: YES
   */
  private String salt;

  /**
   * 备注: 完成时间 是否允许为null: YES
   */
  private Date finishTime;

  /**
   * 备注: 创建时间 是否允许为null: YES
   */
  private Date createTime;

  /**
   * 备注: 更新时间 是否允许为null: YES
   */
  private Date updateTime;


  public static final String ID = "id";

  public static final String BRAND_ID = "brand_id";

  public static final String CHANNEL_NO = "channel_no";

  public static final String MERCHANT_ID = "merchant_id";

  public static final String MERCHANT_NO = "merchant_no";

  public static final String MERCHANT_NAME = "merchant_name";

  public static final String SHORT_NAME = "short_name";

  public static final String COMPANY_TYPE = "company_type";

  public static final String ALI_AUTH_STATE = "ali_auth_state";

  public static final String ALI_MERCHANT_NO = "ali_merchant_no";

  public static final String WX_OFFLINE_AUTH_STATE = "wx_offline_auth_state";

  public static final String WX_OFFLINE_MERCHANT_NO = "wx_offline_merchant_no";

  public static final String WX_ONLINE_AUTH_STATE = "wx_online_auth_state";

  public static final String WX_ONLINE_MERCHANT_NO = "wx_online_merchant_no";

  public static final String BUSINESS_PROVINCE = "business_province";

  public static final String BUSINESS_CITY = "business_city";

  public static final String BUSINESS_DISTRICT = "business_district";

  public static final String BUSINESS_ADDRESS = "business_address";

  public static final String LICENSE_CODE = "license_code";

  public static final String LICENSE_EXPIRE_TYPE = "license_expire_type";

  public static final String LICENSE_START_DATE = "license_start_date";

  public static final String LICENSE_END_DATE = "license_end_date";

  public static final String LICENSE_BUSINESS_SCOPE = "license_business_scope";

  public static final String LICENSE_FOUND_DATE = "license_found_date";

  public static final String LICENSE_REGISTERED_CAPITAL = "license_registered_capital";

  public static final String LICENSE_PROVINCE = "license_province";

  public static final String LICENSE_CITY = "license_city";

  public static final String LICENSE_DISTRICT = "license_district";

  public static final String LICENSE_ADDRESS = "license_address";

  public static final String LEGAL_NAME = "legal_name";

  public static final String LEGAL_CERT_NO = "legal_cert_no";

  public static final String LEGAL_CERT_TYPE = "legal_cert_type";

  public static final String LEGAL_CERT_EXPIRE_TYPE = "legal_cert_expire_type";

  public static final String LEGAL_CERT_START_DATE = "legal_cert_start_date";

  public static final String LEGAL_CERT_END_DATE = "legal_cert_end_date";

  public static final String LEGAL_PHONE = "legal_phone";

  public static final String LEGAL_PROVINCE = "legal_province";

  public static final String LEGAL_CITY = "legal_city";

  public static final String LEGAL_DISTRICT = "legal_district";

  public static final String LEGAL_ADDRESS = "legal_address";

  public static final String CONTACT_EMAIL = "contact_email";

  public static final String BANK_CARD_TYPE = "bank_card_type";

  public static final String BANK_CARD_NO = "bank_card_no";

  public static final String BANK_CARD_NAME = "bank_card_name";

  public static final String BANK_PHONE = "bank_phone";

  public static final String BANK_CERT_NO = "bank_cert_no";

  public static final String BANK_CERT_TYPE = "bank_cert_type";

  public static final String BANK_CERT_EXPIRE_TYPE = "bank_cert_expire_type";

  public static final String BANK_CERT_START_DATE = "bank_cert_start_date";

  public static final String BANK_CERT_END_DATE = "bank_cert_end_date";

  public static final String BANK_BASE_DEPOSIT_NO = "bank_base_deposit_no";

  public static final String BANK_CODE = "bank_code";

  public static final String BANK_NAME = "bank_name";

  public static final String BANK_BRANCH_NAME = "bank_branch_name";

  public static final String BANK_BRANCH_CODE = "bank_branch_code";

  public static final String BANK_CARD_PROVINCE = "bank_card_province";

  public static final String BANK_CARD_CITY = "bank_card_city";

  public static final String BANK_CARD_DISTRICT = "bank_card_district";

  public static final String BANK_CARD_ADDRESS = "bank_card_address";

  public static final String RESOURCE_INFO = "resource_info";

  public static final String SALT = "salt";

  public static final String FINISH_TIME = "finish_time";

  public static final String CREATE_TIME = "create_time";

  public static final String UPDATE_TIME = "update_time";

}
