/*
 * Copyright © 2024 Hangzhou Jiejing Technology Co., Ltd. All rights reserved.
 *
 * The copyright of the company's program code belongs to Hangzhou Jiejing Technology Co., Ltd. No one can illegally copy it without the explicit permission of this website.
 * Official website: www.xiaomai5.com
 *
 *
 *
 * Copyright © 2024 杭州杰竞科技有限公司 版权所有.
 *
 * 本公司程序代码的版权归杭州杰竞科技有限公司所有，未经本网站的明确许可，任何人不得非法复制。
 * 官网: www.xiaomai5.com
 */

package com.jiejing.fitness.finance.repository.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.jiejing.fitness.finance.api.enums.ApplyTypeEnums;
import com.jiejing.paycenter.common.enums.common.OpenStateEnums;
import com.jiejing.paycenter.common.enums.merchant.CompanyTypeEnums;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * <p>
 * 品牌商户申请表（M端以及B端数据回显用，支付以及各状态判断、商户号不使用此表）
 * </p>
 *
 * @author chengyubing, created on 2024-02-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Builder(toBuilder = true)
@NoArgsConstructor
@AllArgsConstructor
public class BrandMerchantApply implements Serializable {

  private static final long serialVersionUID = 8208543338007620669L;

  /**
   * ID
   */
  @TableId(value = "id", type = IdType.ID_WORKER)
  private Long id;

  /**
   * 品牌ID
   */
  private Long brandId;

  /**
   * 场馆ID
   */
  private Long studioId;

  /**
   * 申请单号
   */
  private String applyNo;

  /**
   * 申请类型：OPEN-进件；RE_OPEN-重进件；
   */
  private ApplyTypeEnums applyType;

  /**
   * 渠道号
   */
  private String channelNo;

  /**
   * 商户ID（pay center提供）
   */
  private Long merchantId;

  /**
   * 三方商户号
   */
  private String merchantNo;

  /**
   * 商户名称
   */
  private String merchantName;

  /**
   * 商户简称
   */
  private String shortName;

  /**
   * 企业类型
   */
  private CompanyTypeEnums companyType;

  /**
   * 开通状态：I-初始态；P-处理中；S-成功；F-失败 默认值: I
   */
  private OpenStateEnums openState;

  /**
   * 开通失败原因
   */
  private String openFailMessage;

  /**
   * 支付宝开通状态：I-初始态；S-成功；F-失败 默认值: I
   */
  private OpenStateEnums aliOpenState;

  /**
   * 支付宝认证状态
   */
  private OpenStateEnums aliAuthState;

  /**
   * 支付宝商户号
   */
  private String aliMerchantNo;

  /**
   * 支付宝开通失败原因
   */
  private String aliOpenFailMessage;

  /**
   * 微信线下通道开通状态：I-初始态；S-成功；F-失败 默认值: I
   */
  private OpenStateEnums wxOfflineOpenState;

  /**
   * 微信线下通道认证状态：I-初始态；S-成功；F-失败 默认值: I
   */
  private OpenStateEnums wxOfflineAuthState;

  /**
   * 微信线下通道商户号
   */
  private String wxOfflineMerchantNo;

  /**
   * 微信线下通道开通失败原因
   */
  private String wxOfflineOpenFailMessage;

  /**
   * 微信线上通道开通状态：I-初始态；S-成功；F-失败 默认值: I
   */
  private OpenStateEnums wxOnlineOpenState;

  /**
   * 微信线上通道认证状态：I-初始态；S-成功；F-失败 默认值: I
   */
  private OpenStateEnums wxOnlineAuthState;

  /**
   * 微信线上通道商户号
   */
  private String wxOnlineMerchantNo;

  /**
   * 微信线下通道开通失败原因
   */
  private String wxOnlineOpenFailMessage;

  /**
   * 商户详细信息
   */
  private String merchantInfo;

  /**
   * 盐
   */
  private String salt;

  /**
   * 完成时间
   */
  private Date finishTime;

  /**
   * 创建时间
   */
  private Date createTime;

  /**
   * 更新时间
   */
  private Date updateTime;


  public static final String ID = "id";

  public static final String BRAND_ID = "brand_id";

  public static final String STUDIO_ID = "studio_id";

  public static final String APPLY_NO = "apply_no";

  public static final String APPLY_TYPE = "apply_type";

  public static final String CHANNEL_NO = "channel_no";

  public static final String MERCHANT_ID = "merchant_id";

  public static final String MERCHANT_NO = "merchant_no";

  public static final String MERCHANT_NAME = "merchant_name";

  public static final String SHORT_NAME = "short_name";

  public static final String COMPANY_TYPE = "company_type";

  public static final String OPEN_STATE = "open_state";

  public static final String OPEN_FAIL_MESSAGE = "open_fail_message";

  public static final String ALI_OPEN_STATE = "ali_open_state";

  public static final String ALI_AUTH_STATE = "ali_auth_state";

  public static final String ALI_MERCHANT_NO = "ali_merchant_no";

  public static final String ALI_OPEN_FAIL_MESSAGE = "ali_open_fail_message";

  public static final String WX_OFFLINE_OPEN_STATE = "wx_offline_open_state";

  public static final String WX_OFFLINE_AUTH_STATE = "wx_offline_auth_state";

  public static final String WX_OFFLINE_MERCHANT_NO = "wx_offline_merchant_no";

  public static final String WX_OFFLINE_OPEN_FAIL_MESSAGE = "wx_offline_open_fail_message";

  public static final String WX_ONLINE_OPEN_STATE = "wx_online_open_state";

  public static final String WX_ONLINE_AUTH_STATE = "wx_online_auth_state";

  public static final String WX_ONLINE_MERCHANT_NO = "wx_online_merchant_no";

  public static final String WX_ONLINE_OPEN_FAIL_MESSAGE = "wx_online_open_fail_message";

  public static final String MERCHANT_INFO = "merchant_info";

  public static final String SALT = "salt";

  public static final String FINISH_TIME = "finish_time";

  public static final String CREATE_TIME = "create_time";

  public static final String UPDATE_TIME = "update_time";

}
