package com.jiejing.fitness.finance.api.merchant.vo;

import com.jiejing.paycenter.common.enums.common.OpenStateEnums;
import com.jiejing.paycenter.common.enums.merchant.AuthPhaseEnums;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/2/26 14:37
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "品牌商户认证子渠道VO")
public class BrandMerchantAuthSubChannelVO {

  @ApiModelProperty(value = "申请单")
  private String applyNo;

  /**
   * @see OpenStateEnums
   */
  @ApiModelProperty(value = "授权状态")
  private String state;

  /**
   * AuthPhaseEnums
   */
  @ApiModelProperty(value = "认证阶段")
  private String phase;

  @ApiModelProperty(value = "授权二维码")
  private String qrCode;

  @ApiModelProperty(value = "失败原因")
  private String failMessage;

}
