package com.jiejing.fitness.finance.service.pay.impl;

import com.jiejing.common.exception.BizException;
import com.jiejing.fitness.finance.repository.entity.BrandCashierRecord;
import com.jiejing.fitness.finance.repository.entity.BrandToMerchant;
import com.jiejing.fitness.finance.repository.service.BrandCashierRecordRpService;
import com.jiejing.fitness.finance.repository.service.BrandToMerchantRpService;
import com.jiejing.fitness.finance.service.enums.FinanceErrorEnums;
import com.jiejing.fitness.finance.service.pay.PayService;
import com.jiejing.fitness.finance.service.pay.convert.PayConvert;
import com.jiejing.fitness.finance.service.pay.params.BrandMerchantPayParams;
import com.jiejing.fitness.finance.service.pay.params.BrandMerchantRefundParams;
import com.jiejing.fitness.finance.service.rpc.MerchantRpcService;
import com.jiejing.fitness.finance.service.rpc.PayRpcService;
import com.jiejing.fitness.finance.service.rpc.StudioRpcService;
import com.jiejing.paycenter.api.merchant.vo.MerchantVO;
import com.jiejing.paycenter.api.pay.request.PayRequest;
import com.jiejing.paycenter.api.pay.request.RefundPayRequest;
import com.jiejing.paycenter.api.pay.vo.PayVO;
import com.jiejing.paycenter.api.pay.vo.RefundVO;
import com.jiejing.paycenter.common.enums.pay.PayStateEnums;
import com.jiejing.paycenter.common.event.PayEvent;
import com.jiejing.paycenter.common.event.RefundEvent;
import com.jiejing.studio.api.studio.vo.StudioVO;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/**
 * @author chengyubing
 * @since 2024/2/27 11:06
 */
@Slf4j
@Service
public class PayServiceImpl implements PayService {

  @Value("${finance.brand.merchant.channel}")
  private String channel;

  @Resource
  private BrandToMerchantRpService brandToMerchantRpService;

  @Resource
  private PayRpcService payRpcService;

  @Resource
  private StudioRpcService studioRpcService;

  @Resource
  private BrandCashierRecordRpService brandCashierRecordRpService;

  @Resource
  private MerchantRpcService merchantRpcService;

  @Override
  public PayVO merchantPay(BrandMerchantPayParams params) {
    StudioVO studio = studioRpcService.getStudio(params.getStudioId());
    BrandToMerchant relation = brandToMerchantRpService.getByBrandId(studio.getBrandId(), channel);

    MerchantVO merchant = merchantRpcService.getByMerchantId(relation.getMerchantId());

    BrandCashierRecord record = PayConvert.convertPayInit(params, relation, merchant);
    brandCashierRecordRpService.insert(record);

    PayRequest request = PayConvert.convert(params, record);
    return payRpcService.pay(request);
  }

  @Override
  public void payCallback(PayEvent event) {
    BrandCashierRecord record = brandCashierRecordRpService.getById(Long.parseLong(event.getTransNo()))
        .orElse(null);
    if (null == record) {
      return;
    }

    BrandCashierRecord toModify = PayConvert.convertPay(record, event);
    brandCashierRecordRpService.updateById(toModify);
  }

  @Override
  public RefundVO merchantRefund(BrandMerchantRefundParams params) {
    BrandCashierRecord pay = brandCashierRecordRpService.getById(Long.parseLong(params.getPayTransNo()))
        .orElseThrow(() -> new BizException(FinanceErrorEnums.NOT_EXIST));

    BigDecimal historyRefundActualAmount = brandCashierRecordRpService.sumRefundActualAmountByPayTransNo(
        params.getPayTransNo());

    BrandCashierRecord record = PayConvert.convertRefundInit(params, pay, historyRefundActualAmount);
    brandCashierRecordRpService.insert(record);

    RefundPayRequest request = PayConvert.convert(params, record);
    RefundVO vo = payRpcService.refund(request);

    BrandCashierRecord toModify = PayConvert.convertRefund(record, vo);
    brandCashierRecordRpService.updateById(toModify);
    return vo;
  }

  @Override
  public void refundCallback(RefundEvent event) {
    BrandCashierRecord record = brandCashierRecordRpService.getById(Long.parseLong(event.getTransNo()))
        .orElse(null);
    if (null == record) {
      return;
    }

    BrandCashierRecord toModify = PayConvert.convertRefund(record, event);
    brandCashierRecordRpService.updateById(toModify);
  }

}
