package com.jiejing.fitness.finance.app.controller.merchant;

import com.jiejing.common.model.JsonResult;
import com.jiejing.fitness.finance.api.merchant.BrandMerchantApi;
import com.jiejing.fitness.finance.api.merchant.request.BindBrandMerchantRequest;
import com.jiejing.fitness.finance.api.merchant.request.ListBrandMerchantRequest;
import com.jiejing.fitness.finance.api.merchant.request.UnbindBrandMerchantRequest;
import com.jiejing.fitness.finance.api.merchant.vo.BrandMerchantVO;
import com.jiejing.fitness.finance.service.merchant.BrandMerchantService;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author chengyubing
 * @since 2024/3/7 09:51
 */
@RestController
public class BrandMerchantController implements BrandMerchantApi {

  @Resource
  private BrandMerchantService brandMerchantService;

  @ApiOperation(value = "品牌绑定商户", tags = {TAG})
  @PostMapping(value = "/private/brandMerchant/bind")
  @Override
  public JsonResult<Void> bind(@RequestBody @Valid BindBrandMerchantRequest request) {
    brandMerchantService.bind(request.getBrandId(), request.getMerchantId());
    return JsonResult.success();
  }

  @ApiOperation(value = "品牌解绑商户", tags = {TAG})
  @PostMapping(value = "/private/brandMerchant/unbind")
  @Override
  public JsonResult<Void> unbind(@RequestBody @Valid UnbindBrandMerchantRequest request) {
    brandMerchantService.unbind(request.getBrandId(), request.getMerchantId());
    return JsonResult.success();
  }

  @ApiOperation(value = "查询品牌商户列表", tags = {TAG})
  @PostMapping(value = "/private/brandMerchant/list")
  @Override
  public JsonResult<List<BrandMerchantVO>> list(@RequestBody @Valid ListBrandMerchantRequest request) {
    return JsonResult.success(brandMerchantService.list(request.getBrandId()));
  }

}