package com.jiejing.fitness.finance.service.axf.model;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

/**
 * 售卖订单变更消息通知
 *
 * @author chengyubing
 * @since 2024/9/6 17:36
 */
@Data
public class AlipayCommerceMerchantcardOrderNotifyModel {

  /**
   * 【描述】售卖订单ID（订购单ID）
   * 【示例值】202306240000000001
   */
  @JSONField(name = "card_id")
  private String cardId;

  /**
   * 【描述】业务单id，也是交易组件订单编号
   * 【示例值】202306270007300200080GVS95IS
   */
  @JSONField(name = "order_id")
  private String orderId;

  /**
   * 【描述】创建时间
   * 【示例值】yyyy-MM-dd HH:mm:ss
   */
  @JSONField(name = "create_time")
  private String createTime;

  /**
   * 【描述】卡ID（商品模板ID）
   * 【示例值】2024070422000727041794
   */
  @JSONField(name = "card_template_id")
  private String cardTemplateId;

  /**
   * 【描述】售卖订单状态 订购中: init 可使用: available 已用完: used_up 关闭中: closing 已关闭: closed 已失效: invalid 已支付: paid 已退款:
   * refund 超时关闭: timeout_closed 暂停: pause
   */
  @JSONField(name = "card_status")
  private String cardStatus;

  /**
   * 【描述】卡名称
   * 【示例值】次卡1
   */
  @JSONField(name = "card_name")
  private String cardName;

  /**
   * 卡类型
   * 次卡: TIMES_CARD
   * 周期付: PERIOD_PAY
   * 标准版周期付: AXF_MERCHANT_PERIOD_PAY
   * 周期卡间连版: AXF_PERIOD_PAY_INDIRECT
   * 标准版金额卡: AXF_MONEY_CARD
   */
  @JSONField(name = "card_type")
  private String cardType;

  /**
   * 【描述】支付宝用户的userId。新商户建议使用open_id替代该字段。对于新商户，user_id字段未来计划逐步回收，存量商户可继续使用。如使用open_id，请确认 应用-开发配置-openid配置管理 已启用。无该配置项，可查看openid配置申请。
   * 【示例值】2088741116398093
   */
  @JSONField(name = "user_id")
  private String userId;

  /**
   * 【描述】用于标记支付宝用户在应用下的唯一标识  详情可查看 openid简介
   * 【示例值】074a1CcTG1LelxKe4xQC0zgNdId0nxi95b5lsNpazWYoCo5
   */
  @JSONField(name = "open_id")
  private String openId;

  /**
   * 【描述】总期数，单位：期
   * 【必选条件】当card_type=AXF_MONEY_CARD时，该字段没有值
   */
  @JSONField(name = "total_count")
  private String totalCount;

  /**
   * 【描述】剩余可用期数，单位：期
   * 【必选条件】当card_type=AXF_MONEY_CARD时，该字段没有值
   */
  @JSONField(name = "remain_count")
  private String remainCount;

  /**
   * 【描述】支付宝交易号
   * 【必选条件】当商品的card_type=AXF_MONEY_CARD时有值
   */
  @JSONField(name = "trade_no")
  private String tradeNo;

  /**
   * 【描述】金额卡余额现金价值，单位分
   * 【必选条件】当card_type=AXF_MONEY_CARD时，该字段有值
   */
  @JSONField(name = "usable_cash")
  private String usableCash;

  /**
   * 【描述】金额卡余额面值，单位分
   * 【必选条件】当card_type=AXF_MONEY_CARD时，该字段有值
   */
  @JSONField(name = "available_amount")
  private String availableAmount;

  /**
   * 【描述】小程序id
   * 【示例值】2021004176600010
   */
  @JSONField(name = "merchant_app_id")
  private String merchantAppId;

  /**
   * 【描述】用于区分订购单的取消类型
   * 【枚举值】
   * 用户取消: USER_CANCEL
   * 商户取消: MERCHANT_CANCEL
   * 过期取消: EXPIRED_CANCEL
   * 系统取消: SYSTEM_CANCEL
   */
  @JSONField(name = "cancel_type")
  private String cancelType;

  /**
   * 外部单号
   * 【描述】商户在接入插件时自定义的外部单号
   * 【示例值】123
   */
  @JSONField(name = "out_order_no")
  private String outOrderNo;

  /**
   * 【描述】卡售价，单位分
   */
  @JSONField(name = "sale_price_total")
  private String salePriceTotal;

  /**
   * 【描述】卡原价，单位分
   */
  @JSONField(name = "origin_price_total")
  private String originPriceTotal;

  /**
   * 【描述】售卖订单有效期开始时间
   * 【示例值】yyyy-MM-dd HH:mm:ss
   */
  @JSONField(name = "gmt_active")
  private String gmtActive;

  /**
   * 【描述】售卖订单有效期结束时间
   * 【示例值】yyyy-MM-dd HH:mm:ss
   */
  @JSONField(name = "gmt_expired")
  private String gmtExpired;

}

