package com.jiejing.fitness.finance.api.cashier;

import com.jiejing.common.model.JsonResult;
import com.jiejing.common.model.PageVO;
import com.jiejing.fitness.finance.api.cashier.request.GetBrandCashierByIdRequest;
import com.jiejing.fitness.finance.api.cashier.request.ListBrandCashierByOrderNoRequest;
import com.jiejing.fitness.finance.api.cashier.request.PageBrandCashierRequest;
import com.jiejing.fitness.finance.api.cashier.vo.BrandCashierRecordVO;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @author chengyubing
 * @since 2024/2/29 10:41
 */
@FeignClient(name = "FINANCE", url = "${rpc.url.fit-finance:http://app-fit-finance:7007}", fallbackFactory = BrandCashierApiFallback.class)
public interface BrandCashierApi {

  String TAG = "金融-品牌收银管理";

  @ApiOperation(value = "分页筛选收银流水", tags = {TAG})
  @PostMapping(value = "/private/brandCashier/page")
  JsonResult<PageVO<BrandCashierRecordVO>> page(PageBrandCashierRequest request);

  @ApiOperation(value = "查询收银流水详情", tags = {TAG})
  @PostMapping(value = "/private/brandCashier/getById")
  JsonResult<BrandCashierRecordVO> getById(GetBrandCashierByIdRequest request);

  @ApiOperation(value = "根据订单号查询收银列表", tags = {TAG})
  @PostMapping(value = "/private/brandCashier/getById")
  JsonResult<List<BrandCashierRecordVO>> listByOrderNo(ListBrandCashierByOrderNoRequest request);

}
