package com.jiejing.fitness.finance.api.cashier.vo;

import com.jiejing.fitness.finance.api.enums.BrandCashierTransStateEnums;
import com.jiejing.fitness.finance.api.enums.BrandCashierTransTypeEnums;
import com.jiejing.paycenter.common.enums.merchant.SubChannelEnums;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/2/29 10:43
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "品牌收银流水VO")
public class BrandCashierRecordVO {

  @ApiModelProperty("主键")
  private Long id;

  @ApiModelProperty("交易流水号")
  private String transNo;

  @ApiModelProperty("业务订单号")
  private String orderNo;

  @ApiModelProperty("业务订单类型")
  private Integer orderType;

  @ApiModelProperty("交易类型：PAY-收款；REFUND-退款；")
  private BrandCashierTransTypeEnums transType;

  @ApiModelProperty("品牌ID")
  private Long brandId;

  @ApiModelProperty("场馆ID")
  private Long studioId;

  @ApiModelProperty("商户ID")
  private Long merchantId;

  @ApiModelProperty("商户号")
  private String merchantNo;

  @ApiModelProperty("渠道号")
  private String channelNo;

  @ApiModelProperty("支付子渠道：ALI-支付宝、WX-微信")
  private SubChannelEnums subChannel;

  @ApiModelProperty("交易金额（元）")
  private BigDecimal transAmount;

  @ApiModelProperty("交易手续费率（%）")
  private BigDecimal feeRate;

  @ApiModelProperty("交易手续费")
  private BigDecimal fee;

  @ApiModelProperty("实际金额（元）")
  private BigDecimal actualAmount;

  @ApiModelProperty("交易状态：0-支付初始态；1-支付中；2-支付失败；3-入账中（支付成功）；4-入账成功；5-退款中；6-退款成功；7-退款失败")
  private BrandCashierTransStateEnums transState;

  @ApiModelProperty("付款人姓名")
  private String buyerName;

  @ApiModelProperty("付款人手机号")
  private String buyerPhone;

  @ApiModelProperty("商品名称")
  private String goods;

  @ApiModelProperty("备注")
  private String remark;

  @ApiModelProperty("是否存在关联交易")
  private Boolean existRelatedTrans;

  @ApiModelProperty("关联的交易单号")
  private String relatedTransNo;

  @ApiModelProperty("三方交易单号")
  private String thirdTransNo;

  @ApiModelProperty("错误信息")
  private String failMessage;

  @ApiModelProperty("交易发生时间")
  private Date tradingTime;

  @ApiModelProperty("交易成功时间")
  private Date successTime;

  @ApiModelProperty("入账时间")
  private Date inTime;

  @ApiModelProperty("创建时间")
  private Date createTime;

  @ApiModelProperty("更新时间")
  private Date updateTime;

}
