package com.jiejing.fitness.finance.api.merchant;

import com.jiejing.common.model.JsonResult;
import com.jiejing.common.model.PageVO;
import com.jiejing.fitness.finance.api.merchant.request.ApplyBrandMerchantRequest;
import com.jiejing.fitness.finance.api.merchant.request.AuthBrandMerchantSubChannelRequest;
import com.jiejing.fitness.finance.api.merchant.request.BindBrandMerchantXcxAppIdRequest;
import com.jiejing.fitness.finance.api.merchant.request.GetBrandMerchantApplyRequest;
import com.jiejing.fitness.finance.api.merchant.request.GetAuthBrandMerchantSubChannelRequest;
import com.jiejing.fitness.finance.api.merchant.request.GetBrandMerchantRequest;
import com.jiejing.fitness.finance.api.merchant.request.PageBrandMerchantApplyRequest;
import com.jiejing.fitness.finance.api.merchant.request.BrandMerchantPayRequest;
import com.jiejing.fitness.finance.api.merchant.request.BrandMerchantRefundRequest;
import com.jiejing.fitness.finance.api.merchant.vo.BrandMerchantApplyVO;
import com.jiejing.fitness.finance.api.merchant.vo.BrandMerchantAuthSubChannelVO;
import com.jiejing.fitness.finance.api.merchant.vo.BrandMerchantBindXcxAppIdVO;
import com.jiejing.fitness.finance.api.merchant.vo.BrandMerchantVO;
import com.jiejing.paycenter.api.pay.vo.PayVO;
import com.jiejing.paycenter.api.pay.vo.RefundVO;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * 品牌商户API
 *
 * @author chengyubing
 * @since 2024/2/22 11:49
 */
@FeignClient(name = "FINANCE", url = "${rpc.url.fit-finance:http://app-fit-finance:7007}", fallbackFactory = BrandMerchantApi.class)
public interface BrandMerchantApi {

  String TAG = "金融-品牌商户管理";

  @ApiOperation(value = "品牌入驻商户", tags = {TAG})
  @PostMapping(value = "/private/brandMerchant/apply")
  JsonResult<Void> apply(ApplyBrandMerchantRequest request);

  @ApiOperation(value = "查询品牌当前绑定的商户", tags = {TAG})
  @PostMapping(value = "/private/brandMerchant/get")
  JsonResult<BrandMerchantVO> get(GetBrandMerchantRequest request);

  @ApiOperation(value = "查询品牌进件申请记录", tags = {TAG})
  @PostMapping(value = "/private/brandMerchant/getApply")
  JsonResult<BrandMerchantApplyVO> getApply(GetBrandMerchantApplyRequest request);

  @ApiOperation(value = "分页查询品牌进件申请记录", tags = {TAG})
  @PostMapping(value = "/private/brandMerchant/pageApply")
  JsonResult<PageVO<BrandMerchantApplyVO>> pageApply(PageBrandMerchantApplyRequest request);

  @ApiOperation(value = "绑定微信小程序appId", tags = {TAG})
  @PostMapping(value = "/private/brandMerchant/bindXcxAppId")
  JsonResult<BrandMerchantBindXcxAppIdVO> bindXcxAppId(BindBrandMerchantXcxAppIdRequest request);

  @ApiOperation(value = "校验微信小程序appId绑定结果", tags = {TAG})
  @PostMapping(value = "/private/brandMerchant/checkBindXcxAppId")
  JsonResult<BrandMerchantBindXcxAppIdVO> checkBindXcxAppId(BindBrandMerchantXcxAppIdRequest request);

  @ApiOperation(value = "授权子渠道", tags = {TAG})
  @PostMapping(value = "/private/brandMerchant/authSubChannel")
  JsonResult<BrandMerchantAuthSubChannelVO> authSubChannel(AuthBrandMerchantSubChannelRequest request);

  @ApiOperation(value = "查询授权子渠道结果", tags = {TAG})
  @PostMapping(value = "/private/brandMerchant/listAuthSubChannel")
  JsonResult<List<BrandMerchantAuthSubChannelVO>> listAuthSubChannel(
      GetAuthBrandMerchantSubChannelRequest request);

  @ApiOperation(value = "支付", tags = {TAG})
  @PostMapping(value = "/private/brandMerchant/pay")
  JsonResult<PayVO> pay(BrandMerchantPayRequest request);

  @ApiOperation(value = "退款", tags = {TAG})
  @PostMapping(value = "/private/brandMerchant/refund")
  JsonResult<RefundVO> refund(BrandMerchantRefundRequest request);

}
