package com.jiejing.fitness.finance.api.merchant;

import com.jiejing.common.model.JsonResult;
import com.jiejing.common.model.PageVO;
import com.jiejing.fitness.finance.api.merchant.request.BrandMerchantApplyRequest;
import com.jiejing.fitness.finance.api.merchant.request.BrandMerchantAuthSubChannelRequest;
import com.jiejing.fitness.finance.api.merchant.request.BrandMerchantBindXcxAppIdRequest;
import com.jiejing.fitness.finance.api.merchant.request.BrandMerchantGetApplyRequest;
import com.jiejing.fitness.finance.api.merchant.request.BrandMerchantGetAuthSubChannelRequest;
import com.jiejing.fitness.finance.api.merchant.request.BrandMerchantGetRequest;
import com.jiejing.fitness.finance.api.merchant.request.BrandMerchantPageApplyRequest;
import com.jiejing.fitness.finance.api.merchant.request.BrandMerchantPayRequest;
import com.jiejing.fitness.finance.api.merchant.request.BrandMerchantRefundRequest;
import com.jiejing.fitness.finance.api.merchant.vo.BrandMerchantApplyVO;
import com.jiejing.fitness.finance.api.merchant.vo.BrandMerchantAuthSubChannelVO;
import com.jiejing.fitness.finance.api.merchant.vo.BrandMerchantBindXcxAppIdVO;
import com.jiejing.fitness.finance.api.merchant.vo.BrandMerchantVO;
import com.jiejing.paycenter.api.pay.vo.PayVO;
import com.jiejing.paycenter.api.pay.vo.RefundVO;
import feign.hystrix.FallbackFactory;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * @author chengyubing
 * @since 2024/2/22 11:49
 */
@Component
public class BrandMerchantApiFallback implements FallbackFactory<BrandMerchantApi> {

  @Override
  public BrandMerchantApi create(Throwable throwable) {
    return new BrandMerchantApi() {
      @Override
      public JsonResult<Void> apply(BrandMerchantApplyRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<BrandMerchantVO> get(BrandMerchantGetRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<BrandMerchantApplyVO> getApply(BrandMerchantGetApplyRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<PageVO<BrandMerchantApplyVO>> pageApply(BrandMerchantPageApplyRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<BrandMerchantBindXcxAppIdVO> bindXcxAppId(BrandMerchantBindXcxAppIdRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<BrandMerchantBindXcxAppIdVO> checkBindXcxAppId(
          BrandMerchantBindXcxAppIdRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<BrandMerchantAuthSubChannelVO> authSubChannel(
          BrandMerchantAuthSubChannelRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<List<BrandMerchantAuthSubChannelVO>> listAuthSubChannel(
          BrandMerchantGetAuthSubChannelRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<PayVO> pay(BrandMerchantPayRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<RefundVO> refund(BrandMerchantRefundRequest request) {
        return JsonResult.rpcError();
      }
    };
  }
}
