package com.jiejing.fitness.finance.api.merchant.model;

import com.jiejing.paycenter.common.enums.merchant.CertTypeEnums;
import com.jiejing.paycenter.common.enums.merchant.ExpireTypeEnums;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/2/22 14:02
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "品牌商户：法人信息")
public class BrandLegalInfo {

  @ApiModelProperty(value = "法人证件类型", required = true)
  @NotNull(message = "法人证件类型不能为空")
  private CertTypeEnums legalCertType;

  @ApiModelProperty(value = "法人姓名", required = true)
  @NotBlank(message = "法人姓名不能为空")
  @Size(max = 16)
  private String legalName;

  @ApiModelProperty(value = "法人证件号", required = true)
  @NotBlank(message = "法人证件号不能为空")
  private String legalCertNo;

  @ApiModelProperty(value = "法人证件有效期类型", required = true)
  @NotNull(message = "法人证件有效期类型不能为空")
  private ExpireTypeEnums legalCertExpireType;

  @ApiModelProperty(value = "法人证件有效期开始日期", required = true)
  @NotNull(message = "法人证件有效期开始日期不能为空")
  private Date legalCertStartDate;

  @ApiModelProperty(value = "法人证件有效期截止日期")
  private Date legalCertEndDate;

  @ApiModelProperty(value = "法人手机号")
  private String legalPhone;

  @ApiModelProperty(value = "法人身份证地址")
  private AddressInfo legalAddress;

  @ApiModelProperty(value = "法人邮箱", required = true)
  @NotBlank(message = "法人邮箱不能为空")
  private String legalEmail;

}
