package com.jiejing.fitness.finance.api.merchant.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/2/26 13:58
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "品牌商户查看授权子渠道结果")
public class BrandMerchantGetAuthSubChannelRequest {

  @ApiModelProperty(value = "品牌ID", required = true)
  @NotNull(message = "品牌ID不能为空")
  private Long brandId;

}
