/*
 * Copyright © 2024 Hangzhou Jiejing Technology Co., Ltd. All rights reserved.
 *
 * The copyright of the company's program code belongs to Hangzhou Jiejing Technology Co., Ltd. No one can illegally copy it without the explicit permission of this website.
 * Official website: www.xiaomai5.com
 *
 *
 *
 * Copyright © 2024 杭州杰竞科技有限公司 版权所有.
 *
 * 本公司程序代码的版权归杭州杰竞科技有限公司所有，未经本网站的明确许可，任何人不得非法复制。
 * 官网: www.xiaomai5.com
 */

package com.jiejing.fitness.finance.repository.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jiejing.common.utils.text.StringUtil;
import com.jiejing.fitness.finance.repository.entity.BrandMerchantApply;
import com.jiejing.fitness.finance.repository.mapper.BrandMerchantApplyMapper;
import com.jiejing.fitness.finance.repository.query.PageBrandMerchantApplyQuery;
import com.jiejing.mbp.MapperRepoService;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 品牌商户申请表（M端以及B端数据回显用，支付以及各状态判断、商户号不使用此表） 服务实现类
 * </p>
 *
 * @author chengyubing, created on 2024-02-22
 */
@Service
public class BrandMerchantApplyRpService extends
    MapperRepoService<Long, BrandMerchantApply, BrandMerchantApplyMapper> {

  public BrandMerchantApply getLatestOneSuccessByBrandId(Long brandId) {
    return this.baseMapper.getLatestOneSuccessByBrandId(brandId);
  }

  public Page<BrandMerchantApply> page(PageBrandMerchantApplyQuery params) {
    QueryWrapper<BrandMerchantApply> wrapper = new QueryWrapper<>();
    if (StringUtil.isNotBlank(params.getShortName())) {
      wrapper.like(BrandMerchantApply.SHORT_NAME, params.getShortName());
    }
    if (null != params.getApplyType()) {
      wrapper.eq(BrandMerchantApply.APPLY_TYPE, params.getApplyType());
    }
    if (null != params.getStudioId()) {
      wrapper.eq(BrandMerchantApply.STUDIO_ID, params.getStudioId());
    }
    if (null != params.getCompanyType()) {
      wrapper.eq(BrandMerchantApply.COMPANY_TYPE, params.getCompanyType());
    }
    if (StringUtil.isNotBlank(params.getMerchantName())) {
      wrapper.like(BrandMerchantApply.MERCHANT_NAME, params.getMerchantName());
    }
    if (null != params.getOpenState()) {
      wrapper.eq(BrandMerchantApply.OPEN_STATE, params.getOpenState());
    }
    if (StringUtil.isNotBlank(params.getMerchantNo())) {
      wrapper.eq(BrandMerchantApply.MERCHANT_NO, params.getMerchantNo());
    }
    if (StringUtil.isNotBlank(params.getAliMerchantNo())) {
      wrapper.eq(BrandMerchantApply.ALI_MERCHANT_NO, params.getAliMerchantNo());
    }
    if (StringUtil.isNotBlank(params.getWxOnlineMerchantNo())) {
      wrapper.eq(BrandMerchantApply.WX_ONLINE_MERCHANT_NO, params.getWxOnlineMerchantNo());
    }
    if (StringUtil.isNotBlank(params.getWxOfflineMerchantNo())) {
      wrapper.eq(BrandMerchantApply.WX_OFFLINE_MERCHANT_NO, params.getWxOfflineMerchantNo());
    }
    return this.findByWrapperPage(wrapper, params.getCurrent(), params.getSize());
  }

}
