package com.jiejing.fitness.finance.service.rpc;

import com.jiejing.common.model.JsonResult;
import com.jiejing.common.request.IdRequest;
import com.jiejing.studio.api.studio.StudioApi;
import com.jiejing.studio.api.studio.vo.StudioVO;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author chengyubing
 * @since 2024/2/20 16:52
 */
@Slf4j
@Service
public class StudioRpcService {

  @Resource
  private StudioApi studioApi;

  public StudioVO getStudio(Long studioId) {
    JsonResult<StudioVO> result = studioApi.getStudio(IdRequest.builder().id(studioId).build());
    result.assertSuccess();
    return result.getResult();
  }

}
