package com.jiejing.fitness.finance.api.merchant;

import com.jiejing.common.model.JsonResult;
import com.jiejing.common.model.PageVO;
import com.jiejing.fitness.finance.api.merchant.request.BrandMerchantApplyRequest;
import com.jiejing.fitness.finance.api.merchant.request.BrandMerchantAuthSubChannelRequest;
import com.jiejing.fitness.finance.api.merchant.request.BrandMerchantBindXcxAppIdRequest;
import com.jiejing.fitness.finance.api.merchant.request.BrandMerchantGetApplyRequest;
import com.jiejing.fitness.finance.api.merchant.request.BrandMerchantGetRequest;
import com.jiejing.fitness.finance.api.merchant.request.BrandMerchantPageApplyRequest;
import com.jiejing.fitness.finance.api.merchant.vo.BrandMerchantApplyVO;
import com.jiejing.fitness.finance.api.merchant.vo.BrandMerchantAuthSubChannelVO;
import com.jiejing.fitness.finance.api.merchant.vo.BrandMerchantBindXcxAppIdVO;
import com.jiejing.fitness.finance.api.merchant.vo.BrandMerchantVO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * 品牌商户API
 *
 * @author chengyubing
 * @since 2024/2/22 11:49
 */
@FeignClient(name = "PAYCENTER", url = "http://app-paycenter:7007", fallbackFactory = BrandMerchantApi.class)
public interface BrandMerchantApi {

  String TAG = "金融-品牌商户管理";

  @ApiOperation(value = "品牌入驻商户", tags = {TAG})
  @PostMapping(value = "/private/brandMerchant/apply")
  JsonResult<Void> apply(BrandMerchantApplyRequest request);

  @ApiOperation(value = "查询品牌当前绑定的商户", tags = {TAG})
  @PostMapping(value = "/private/brandMerchant/get")
  JsonResult<BrandMerchantVO> get(BrandMerchantGetRequest request);

  @ApiOperation(value = "查询品牌进件申请记录", tags = {TAG})
  @PostMapping(value = "/private/brandMerchant/getApply")
  JsonResult<BrandMerchantApplyVO> getApply(BrandMerchantGetApplyRequest request);

  @ApiOperation(value = "分页查询品牌进件申请记录", tags = {TAG})
  @PostMapping(value = "/private/brandMerchant/pageApply")
  JsonResult<PageVO<BrandMerchantApplyVO>> pageApply(BrandMerchantPageApplyRequest request);

  @ApiOperation(value = "绑定微信小程序appId", tags = {TAG})
  @PostMapping(value = "/private/brandMerchant/bindXcxAppId")
  JsonResult<BrandMerchantBindXcxAppIdVO> bindXcxAppId(BrandMerchantBindXcxAppIdRequest request);

  @ApiOperation(value = "校验微信小程序appId绑定结果", tags = {TAG})
  @PostMapping(value = "/private/brandMerchant/checkBindXcxAppId")
  JsonResult<BrandMerchantBindXcxAppIdVO> checkBindXcxAppId(BrandMerchantBindXcxAppIdRequest request);

  @ApiOperation(value = "授权子渠道", tags = {TAG})
  @PostMapping(value = "/private/brandMerchant/authSubChannel")
  JsonResult<BrandMerchantAuthSubChannelVO> authSubChannel(BrandMerchantAuthSubChannelRequest request);

}
