/*
 * Copyright © 2024 Hangzhou Jiejing Technology Co., Ltd. All rights reserved.
 *
 * The copyright of the company's program code belongs to Hangzhou Jiejing Technology Co., Ltd. No one can illegally copy it without the explicit permission of this website.
 * Official website: www.xiaomai5.com
 *
 *
 *
 * Copyright © 2024 杭州杰竞科技有限公司 版权所有.
 *
 * 本公司程序代码的版权归杭州杰竞科技有限公司所有，未经本网站的明确许可，任何人不得非法复制。
 * 官网: www.xiaomai5.com
 */

package com.jiejing.fitness.finance.repository.service;

import com.jiejing.fitness.finance.repository.entity.BrandBindWxAppIdApply;
import com.jiejing.fitness.finance.repository.mapper.BrandBindWxAppIdApplyMapper;
import com.jiejing.mbp.MapperRepoService;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 品牌商户绑定微信appId申请表 服务实现类
 * </p>
 *
 * @author chengyubing, created on 2024-02-26
 */
@Service
public class BrandBindWxAppIdApplyRpService extends
    MapperRepoService<Long, BrandBindWxAppIdApply, BrandBindWxAppIdApplyMapper> {

  public BrandBindWxAppIdApply getLatestSuccessByMerchantIdAndAppId(Long merchantId, String appId) {
    return this.baseMapper.selectLatestSuccess(merchantId, appId);
  }

  public BrandBindWxAppIdApply getLatestByMerchantIdAndAppId(Long merchantId, String appId) {
    return this.baseMapper.selectLatestOne(merchantId, appId);
  }

}
