package com.jiejing.fitness.finance.app.controller.config;

import com.alibaba.fastjson.JSONObject;
import com.jiejing.common.model.JsonResult;
import com.jiejing.fitness.finance.api.config.FinanceConfigApi;
import com.jiejing.fitness.finance.api.config.request.GetConfigRequest;
import com.jiejing.fitness.finance.service.global.ConfigService;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author chengyubing
 * @since 2024/6/4 11:25
 */
@RestController
public class FinanceConfigController implements FinanceConfigApi {

  @Resource
  private ConfigService configService;

  @ApiOperation(value = "获取finance的配置信息", tags = {TAG})
  @PostMapping(value = "/private/financeConfig/get")
  @Override
  public JsonResult<JSONObject> get(@RequestBody @Valid GetConfigRequest request) {
    return JsonResult.success(configService.getConfig(request.getKey()));
  }

}
