package com.jiejing.fitness.finance.api.merchant.request.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/2/22 14:03
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "品牌商户：进件资料")
public class BrandResourceInfo {

  @ApiModelProperty(value = "资源ID", required = true)
  @NotNull(message = "资源ID不能为空")
  private Long resourceId;

  @ApiModelProperty(value = "资源链接", required = true)
  private String url;

}
