package com.jiejing.fitness.finance.api.merchant;

import com.jiejing.common.model.JsonResult;
import com.jiejing.common.model.PageVO;
import com.jiejing.fitness.finance.api.merchant.request.ApplyStudioMerchantRequest;
import com.jiejing.fitness.finance.api.merchant.request.AuthStudioSubChannelRequest;
import com.jiejing.fitness.finance.api.merchant.request.BindStudioMerchantRequest;
import com.jiejing.fitness.finance.api.merchant.request.BindStudioMerchantXcxAppIdRequest;
import com.jiejing.fitness.finance.api.merchant.request.CheckUnbindStudioMerchantRequest;
import com.jiejing.fitness.finance.api.merchant.request.GetAuthStudioSubChannelRequest;
import com.jiejing.fitness.finance.api.merchant.request.GetOpenIdRequest;
import com.jiejing.fitness.finance.api.merchant.request.GetStudioLatestMerchantApplyRequest;
import com.jiejing.fitness.finance.api.merchant.request.GetStudioMerchantApplyRequest;
import com.jiejing.fitness.finance.api.merchant.request.GetStudioMerchantRequest;
import com.jiejing.fitness.finance.api.merchant.request.PageStudioMerchantApplyRequest;
import com.jiejing.fitness.finance.api.merchant.request.StudioMerchantPayRequest;
import com.jiejing.fitness.finance.api.merchant.request.StudioMerchantRefundRequest;
import com.jiejing.fitness.finance.api.merchant.request.UnbindStudioMerchantRequest;
import com.jiejing.fitness.finance.api.merchant.vo.StudioMerchantApplyVO;
import com.jiejing.fitness.finance.api.merchant.vo.StudioMerchantAuthSubChannelVO;
import com.jiejing.fitness.finance.api.merchant.vo.StudioMerchantBindXcxAppIdVO;
import com.jiejing.fitness.finance.api.merchant.vo.StudioMerchantCheckRefundVO;
import com.jiejing.fitness.finance.api.merchant.vo.StudioMerchantRefundVO;
import com.jiejing.fitness.finance.api.merchant.vo.StudioMerchantVO;
import com.jiejing.paycenter.common.model.vo.PayVO;
import com.jiejing.paycenter.common.model.vo.RefundVO;
import feign.hystrix.FallbackFactory;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * @author chengyubing
 * @since 2024/3/5 09:41
 */
@Component
public class StudioMerchantApiFallback implements FallbackFactory<StudioMerchantApi> {

  @Override
  public StudioMerchantApi create(Throwable throwable) {
    return new StudioMerchantApi() {
      @Override
      public JsonResult<StudioMerchantVO> getMerchant(GetStudioMerchantRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<Long> apply(ApplyStudioMerchantRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<Void> bind(BindStudioMerchantRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<List<String>> checkUnbind(CheckUnbindStudioMerchantRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<Void> unbind(UnbindStudioMerchantRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<StudioMerchantApplyVO> getApply(GetStudioMerchantApplyRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<StudioMerchantApplyVO> getLatestApply(GetStudioLatestMerchantApplyRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<StudioMerchantApplyVO> getLatestSuccessApply(
          GetStudioLatestMerchantApplyRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<PageVO<StudioMerchantApplyVO>> pageApply(PageStudioMerchantApplyRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<StudioMerchantBindXcxAppIdVO> bindXcxAppId(
          BindStudioMerchantXcxAppIdRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<StudioMerchantAuthSubChannelVO> authSubChannel(AuthStudioSubChannelRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<StudioMerchantAuthSubChannelVO> syncAuthSubChannel(
          AuthStudioSubChannelRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<List<StudioMerchantAuthSubChannelVO>> listAuthSubChannel(
          GetAuthStudioSubChannelRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<String> getOpenId(GetOpenIdRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<PayVO> pay(StudioMerchantPayRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<StudioMerchantCheckRefundVO> checkBeforeRefund(StudioMerchantRefundRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<StudioMerchantRefundVO> refund(StudioMerchantRefundRequest request) {
        return JsonResult.rpcError();
      }
    };
  }
}
