package com.jiejing.fitness.finance.api.merchant.vo;

import com.jiejing.paycenter.common.enums.merchant.ExpireTypeEnums;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/2/22 13:57
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "品牌商户：营业执照信息")
public class BrandLicenseVO {

  @ApiModelProperty(value = "营业执照编号")
  private String licenseCode;

  /**
   * @see ExpireTypeEnums
   */
  @ApiModelProperty(value = "营业执照有效期类型")
  private String licenseExpireType;

  @ApiModelProperty(value = "营业执照有效期开始日期")
  private Date licenseStartDate;

  @ApiModelProperty(value = "营业执照有效期截止日期")
  private Date licenseEndDate;

  @ApiModelProperty(value = "经营范围")
  private String businessScope;

  @ApiModelProperty(value = "成立时间")
  private Date foundDate;

  @ApiModelProperty(value = "注册资本", notes = "国营企业、私营企业、外资企业、事业单位、其他、集体经济必填；政府机构、个体工商户可为空")
  private String registeredCapital;

  @ApiModelProperty(value = "注册地址")
  private AddressVO licenseAddress;

}
