package com.jiejing.fitness.finance.api.cashier;

import com.jiejing.common.model.JsonResult;
import com.jiejing.common.model.PageVO;
import com.jiejing.fitness.finance.api.cashier.request.GetStudioCashierByIdRequest;
import com.jiejing.fitness.finance.api.cashier.request.ListStudioCashierByOrderNoRequest;
import com.jiejing.fitness.finance.api.cashier.request.PageStudioCashierRequest;
import com.jiejing.fitness.finance.api.cashier.vo.StudioCashierRecordVO;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @author chengyubing
 * @since 2024/2/29 10:41
 */
@FeignClient(name = "FINANCE", url = "${rpc.url.fit-finance:http://app-fit-finance:7008}", fallbackFactory = StudioCashierApiFallback.class)
public interface StudioCashierApi {

  String TAG = "金融-场馆收银管理";

  @ApiOperation(value = "分页筛选收银流水", tags = {TAG})
  @PostMapping(value = "/private/studioCashier/page")
  JsonResult<PageVO<StudioCashierRecordVO>> page(PageStudioCashierRequest request);

  @ApiOperation(value = "查询收银流水详情", tags = {TAG})
  @PostMapping(value = "/private/studioCashier/getById")
  JsonResult<StudioCashierRecordVO> getById(GetStudioCashierByIdRequest request);

  @ApiOperation(value = "根据订单号查询收银列表", tags = {TAG})
  @PostMapping(value = "/private/studioCashier/listByOrderNo")
  JsonResult<List<StudioCashierRecordVO>> listByOrderNo(ListStudioCashierByOrderNoRequest request);

}
