package com.jiejing.fitness.finance.service.cashier.convert;

import com.google.common.collect.Lists;
import com.jiejing.common.model.PageVO;
import com.jiejing.common.utils.collection.CollectionUtil;
import com.jiejing.common.utils.convert.BeanUtil;
import com.jiejing.fitness.finance.api.cashier.vo.StudioCashierRecordVO;
import com.jiejing.fitness.finance.repository.entity.StudioCashierRecord;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;

/**
 * @author chengyubing
 * @since 2024/2/29 11:09
 */
public class CashierConvert {

  public static StudioCashierRecordVO convertVO(StudioCashierRecord record) {
    return BeanUtil.map(record, StudioCashierRecordVO.class);
  }

  public static List<StudioCashierRecordVO> convertList(List<StudioCashierRecord> list) {
    if (CollectionUtil.isEmpty(list)) {
      return Lists.newArrayList();
    }
    return list.stream().map(CashierConvert::convertVO).collect(Collectors.toList());
  }

  public static PageVO<StudioCashierRecordVO> convertPageVO(Page<StudioCashierRecord> page) {
    return PageVO.convert(page, convertList(page.getContent()));
  }

}
