package com.jiejing.fitness.finance.service.merchant.impl;

import com.jiejing.fitness.finance.api.enums.PartyTypeEnums;
import com.jiejing.fitness.finance.api.merchant.vo.StudioMerchantVO;
import com.jiejing.fitness.finance.repository.entity.PartyToMerchant;
import com.jiejing.fitness.finance.repository.entity.StudioMerchantApply;
import com.jiejing.fitness.finance.repository.service.PartyToMerchantRpService;
import com.jiejing.fitness.finance.repository.service.StudioMerchantApplyRpService;
import com.jiejing.fitness.finance.service.global.ConfigService;
import com.jiejing.fitness.finance.service.merchant.BrandMerchantService;
import com.jiejing.fitness.finance.service.merchant.convert.MerchantConvert;
import com.jiejing.fitness.finance.service.rpc.MerchantRpcService;
import com.jiejing.paycenter.api.merchant.vo.MerchantVO;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/**
 * 品牌商户服务
 *
 * @author chengyubing
 * @since 2024/2/20 14:01
 */
@Slf4j
@Service
public class BrandMerchantServiceImpl implements BrandMerchantService {

  @Value("${finance.brand.merchant.channel}")
  private String channel;

  @Resource
  private StudioMerchantApplyRpService studioMerchantApplyRpService;

  @Resource
  private PartyToMerchantRpService partyToMerchantRpService;

  @Resource
  private MerchantRpcService merchantRpcService;

  @Resource
  private ConfigService configService;

  @Override
  public void bind(Long brandId, Long merchantId) {
    PartyToMerchant exist = partyToMerchantRpService.getOneByPartyAndMerchantId(channel, brandId,
        PartyTypeEnums.BRAND, merchantId);
    if (null != exist) {
      return;
    }

    StudioMerchantApply apply = studioMerchantApplyRpService.getLatestOneSuccessByMerchantId(merchantId);
    partyToMerchantRpService.insert(
        MerchantConvert.convertPartyToMerchant(apply.getChannelNo(), brandId, PartyTypeEnums.BRAND,
            apply.getMerchantId(), apply.getMerchantNo()));
  }

  @Override
  public void unbind(Long brandId, Long merchantId) {
    partyToMerchantRpService.deleteByPartyAndMerchantId(brandId, PartyTypeEnums.BRAND, merchantId);
  }

  @Override
  public List<StudioMerchantVO> list(Long brandId) {
    List<PartyToMerchant> relations = partyToMerchantRpService.listByParty(brandId, PartyTypeEnums.BRAND,
        channel);
    List<Long> merchantIds = relations.stream().map(PartyToMerchant::getMerchantId)
        .collect(Collectors.toList());
    List<MerchantVO> merchants = merchantRpcService.listByIds(merchantIds);
    return MerchantConvert.convertBrandMerchantList(brandId, merchants,
        configService.getDefaultBrandSubChannelInfo());
  }

}
