package com.jiejing.fitness.finance.api.merchant.vo;

import com.jiejing.common.swagger.EnumMapping;
import com.jiejing.fitness.finance.api.merchant.request.model.BrandResourceInfo;
import com.jiejing.paycenter.common.enums.common.OpenStateEnums;
import com.jiejing.paycenter.common.enums.merchant.CompanyTypeEnums;
import com.jiejing.paycenter.common.model.vo.SubChannelConfigVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Map;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/2/22 16:22
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "场馆当前绑定的商户信息VO")
public class StudioMerchantVO {

  @ApiModelProperty("场馆ID")
  private Long studioId;

  @ApiModelProperty("品牌ID")
  private Long brandId;

  @ApiModelProperty("渠道号")
  private String channelNo;

  @ApiModelProperty("商户ID（pay center提供）")
  private Long merchantId;

  @ApiModelProperty("三方商户号")
  private String merchantNo;

  @ApiModelProperty("商户名称")
  private String merchantName;

  @ApiModelProperty("商户简称")
  private String shortName;

  @EnumMapping(enumClass = CompanyTypeEnums.class)
  @ApiModelProperty("企业类型")
  private String companyType;

  @EnumMapping(enumClass = OpenStateEnums.class)
  @ApiModelProperty("开通状态")
  private String openState;

  @EnumMapping(enumClass = OpenStateEnums.class)
  @ApiModelProperty("支付宝开通状态")
  private String aliOpenState;

  @EnumMapping(enumClass = OpenStateEnums.class)
  @ApiModelProperty("支付宝认证状态")
  private String aliAuthState;

  @ApiModelProperty("支付宝商户号")
  private String aliMerchantNo;

  @ApiModelProperty("支付宝开通失败原因")
  private String aliOpenFailMessage;

  @EnumMapping(enumClass = OpenStateEnums.class)
  @ApiModelProperty("微信线下通道开通状态")
  private String wxOfflineOpenState;

  @EnumMapping(enumClass = OpenStateEnums.class)
  @ApiModelProperty("微信线下通道认证状态")
  private String wxOfflineAuthState;

  @ApiModelProperty("微信线下通道商户号")
  private String wxOfflineMerchantNo;

  @ApiModelProperty("微信线下通道开通失败原因")
  private String wxOfflineOpenFailMessage;

  @EnumMapping(enumClass = OpenStateEnums.class)
  @ApiModelProperty("微信线上通道开通状态")
  private String wxOnlineOpenState;

  @EnumMapping(enumClass = OpenStateEnums.class)
  @ApiModelProperty("微信线上通道认证状态")
  private String wxOnlineAuthState;

  @ApiModelProperty("微信线上通道商户号")
  private String wxOnlineMerchantNo;

  @ApiModelProperty("微信线下通道开通失败原因")
  private String wxOnlineOpenFailMessage;

  @ApiModelProperty(value = "营业执照")
  private BrandLicenseVO license;

  @ApiModelProperty(value = "法人信息")
  private BrandLegalVO legal;

  @ApiModelProperty(value = "结算卡信息")
  private BrandBankCardVO bankCard;

  @ApiModelProperty(value = "进件所需资料")
  private Map<String, BrandResourceInfo> resourceMap;

  @ApiModelProperty("子渠道配置记录")
  private List<SubChannelConfigVO> subChannelConfigs;

}
