package com.jiejing.fitness.finance.app.controller.pay;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jiejing.common.exception.BizException;
import com.jiejing.common.model.JsonResult;
import com.jiejing.common.utils.convert.BeanUtil;
import com.jiejing.fitness.enums.finance.PayOrderTypeEnum;
import com.jiejing.fitness.finance.api.pay.FitPayApi;
import com.jiejing.fitness.finance.api.pay.request.NativePayRequest;
import com.jiejing.fitness.finance.service.enums.FinanceErrorEnums;
import com.jiejing.fitness.finance.service.pay.PayService;
import com.jiejing.fitness.finance.service.pay.params.NativePayParams;
import com.jiejing.paycenter.api.pay.PayApi;
import com.jiejing.paycenter.api.pay.request.PayRequest;
import com.jiejing.paycenter.api.pay.request.SyncPayRequest;
import com.jiejing.paycenter.common.enums.pay.PayTypeEnums;
import com.jiejing.paycenter.common.model.vo.PayVO;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.Date;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author chengyubing
 * @since 2024/4/11 10:10
 */
@RestController
public class FitPayController implements FitPayApi {

  @Resource
  private PayService payService;

  @Resource
  private PayApi payApi;

  @ApiOperation(value = "Native支付", tags = {TAG})
  @PostMapping(value = "/private/pay/nativePay")
  @Override
  public JsonResult<PayVO> nativePay(@RequestBody @Valid NativePayRequest request) {
    return JsonResult.success(payService.nativePay(BeanUtil.map(request, NativePayParams.class)));
  }

  @ApiOperation(value = "同步支付状态", tags = {TAG})
  @PostMapping(value = "/private/pay/get")
  public JsonResult<PayVO> get(@RequestBody @Valid SyncPayRequest request) {
    return payApi.syncPay(request);
  }

}
