package com.jiejing.fitness.finance.api.merchant;

import com.jiejing.common.model.JsonResult;
import com.jiejing.common.model.PageVO;
import com.jiejing.fitness.finance.api.merchant.request.ApplyBrandMerchantRequest;
import com.jiejing.fitness.finance.api.merchant.request.GetBrandMerchantApplyRequest;
import com.jiejing.fitness.finance.api.merchant.request.GetBrandMerchantRequest;
import com.jiejing.fitness.finance.api.merchant.request.PageBrandMerchantApplyRequest;
import com.jiejing.fitness.finance.api.merchant.vo.BrandMerchantApplyVO;
import com.jiejing.fitness.finance.api.merchant.vo.BrandMerchantVO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * 品牌商户API
 *
 * @author chengyubing
 * @since 2024/2/22 11:49
 */
@FeignClient(name = "PAYCENTER", url = "http://app-paycenter:7007", fallbackFactory = BrandMerchantApi.class)
public interface BrandMerchantApi {

  String TAG = "金融-品牌商户管理";

  @ApiOperation(value = "品牌入驻商户", tags = {TAG})
  @PostMapping(value = "/private/brandMerchant/apply")
  JsonResult<Void> apply(ApplyBrandMerchantRequest request);

  @ApiOperation(value = "查询品牌当前绑定的商户", tags = {TAG})
  @PostMapping(value = "/private/brandMerchant/get")
  JsonResult<BrandMerchantVO> get(GetBrandMerchantRequest request);

  @ApiOperation(value = "查询品牌进件申请记录", tags = {TAG})
  @PostMapping(value = "/private/brandMerchant/getApply")
  JsonResult<BrandMerchantApplyVO> getApply(GetBrandMerchantApplyRequest request);

  @ApiOperation(value = "分页查询品牌进件申请记录", tags = {TAG})
  @PostMapping(value = "/private/brandMerchant/pageApply")
  JsonResult<PageVO<BrandMerchantApplyVO>> pageApply(PageBrandMerchantApplyRequest request);

}
