package com.jiejing.fitness.finance.api.bank;

import com.jiejing.common.model.JsonResult;
import com.jiejing.common.model.PageVO;
import com.jiejing.fitness.finance.api.bank.request.PageBankRequest;
import com.jiejing.fitness.finance.api.bank.request.PageBranchBankRequest;
import com.jiejing.fitness.finance.api.bank.vo.BankVO;
import com.jiejing.fitness.finance.api.bank.vo.BranchBankVO;
import feign.hystrix.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * @author chengyubing
 * @since 2024/4/1 14:39
 */
@Component
public class BankApiFallback implements FallbackFactory<BankApi> {

  @Override
  public BankApi create(Throwable throwable) {
    return new BankApi() {
      @Override
      public JsonResult<PageVO<BankVO>> pageBank(PageBankRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<PageVO<BranchBankVO>> pageBranchBank(PageBranchBankRequest request) {
        return JsonResult.rpcError();
      }
    };
  }
}
