/*
 * Copyright © 2024 Hangzhou Jiejing Technology Co., Ltd. All rights reserved.
 *
 * The copyright of the company's program code belongs to Hangzhou Jiejing Technology Co., Ltd. No one can illegally copy it without the explicit permission of this website.
 * Official website: www.xiaomai5.com
 *
 *
 *
 * Copyright © 2024 杭州杰竞科技有限公司 版权所有.
 *
 * 本公司程序代码的版权归杭州杰竞科技有限公司所有，未经本网站的明确许可，任何人不得非法复制。
 * 官网: www.xiaomai5.com
 */

package com.jiejing.fitness.finance.repository.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jiejing.common.utils.collection.CollectionUtil;
import com.jiejing.fitness.enums.finance.PartyTypeEnum;
import com.jiejing.fitness.finance.repository.entity.PartyToMerchant;
import com.jiejing.fitness.finance.repository.mapper.PartyToMerchantMapper;
import com.jiejing.mbp.MapperRepoService;
import java.util.List;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 商户关联表 服务实现类
 * </p>
 *
 * @author chengyubing, created on 2024-03-04
 */
@Service
public class PartyToMerchantRpService extends
    MapperRepoService<Long, PartyToMerchant, PartyToMerchantMapper> {

  public List<PartyToMerchant> listByParty(Long partyId, PartyTypeEnum partyType, String channelNo) {
    QueryWrapper<PartyToMerchant> wrapper = new QueryWrapper<>();
    wrapper.eq(PartyToMerchant.PARTY_ID, partyId);
    wrapper.eq(PartyToMerchant.PARTY_TYPE, partyType);
    wrapper.eq(PartyToMerchant.CHANNEL_NO, channelNo);
    return this.baseMapper.selectList(wrapper);
  }

  public PartyToMerchant getByStudioId(Long studioId, String channelNo) {
    QueryWrapper<PartyToMerchant> wrapper = new QueryWrapper<>();
    wrapper.eq(PartyToMerchant.PARTY_ID, studioId);
    wrapper.eq(PartyToMerchant.PARTY_TYPE, PartyTypeEnum.STUDIO);
    wrapper.eq(PartyToMerchant.CHANNEL_NO, channelNo);
    List<PartyToMerchant> list = this.baseMapper.selectList(wrapper);
    return CollectionUtil.isEmpty(list) ? null : list.get(0);
  }

  public PartyToMerchant getOneByPartyAndMerchantId(String channelNo, Long partyId, PartyTypeEnum partyType,
      Long merchantId) {
    QueryWrapper<PartyToMerchant> wrapper = new QueryWrapper<>();
    wrapper.eq(PartyToMerchant.PARTY_ID, partyId);
    wrapper.eq(PartyToMerchant.MERCHANT_ID, merchantId);
    wrapper.eq(PartyToMerchant.PARTY_TYPE, partyType);
    wrapper.eq(PartyToMerchant.CHANNEL_NO, channelNo);
    return this.baseMapper.selectOne(wrapper);
  }

  public void deleteByParty(Long partyId, PartyTypeEnum partyType) {
    QueryWrapper<PartyToMerchant> wrapper = new QueryWrapper<>();
    wrapper.eq(PartyToMerchant.PARTY_ID, partyId);
    wrapper.eq(PartyToMerchant.PARTY_TYPE, partyType);
    this.baseMapper.delete(wrapper);
  }

  public void deleteByPartyAndMerchantId(Long partyId, PartyTypeEnum partyType, Long merchantId) {
    QueryWrapper<PartyToMerchant> wrapper = new QueryWrapper<>();
    wrapper.eq(PartyToMerchant.PARTY_ID, partyId);
    wrapper.eq(PartyToMerchant.PARTY_TYPE, partyType);
    wrapper.eq(PartyToMerchant.MERCHANT_ID, merchantId);
    this.baseMapper.delete(wrapper);
  }

  public List<PartyToMerchant> listByMerchantIdsAndPartyType(List<Long> merchantIds,
      PartyTypeEnum partyType) {
    QueryWrapper<PartyToMerchant> wrapper = new QueryWrapper<>();
    wrapper.in(PartyToMerchant.MERCHANT_ID, merchantIds);
    wrapper.eq(PartyToMerchant.PARTY_TYPE, partyType);
    return this.baseMapper.selectList(wrapper);
  }
}
