package com.jiejing.fitness.finance.service.cashier;

import com.jiejing.common.model.PageVO;
import com.jiejing.fitness.finance.api.cashier.vo.StudioCashierRecordVO;
import com.jiejing.fitness.finance.service.cashier.params.PageStudioCashierParams;
import java.util.List;

/**
 * @author chengyubing
 * @since 2024/2/29 11:05
 */
public interface StudioCashierService {

  /**
   * 查询详情
   *
   * @param id ID
   * @return 结果
   */
  StudioCashierRecordVO getById(Long id);

  /**
   * 根据订单号查询列表
   *
   * @param orderNo 订单号
   * @return 结果
   */
  List<StudioCashierRecordVO> listByOrderNo(String orderNo);

  /**
   * 根据业务子订单号查询列表
   *
   * @param subOrderNo 业务子订单号
   * @return 结果
   */
  List<StudioCashierRecordVO> listBySubOrderNo(String subOrderNo);

  /**
   * 分页
   *
   * @param params 参数
   * @return 结果
   */
  PageVO<StudioCashierRecordVO> page(PageStudioCashierParams params);

}
