package com.jiejing.fitness.finance.api.axf.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author chengyubing
 * @since 2024/9/7 11:08
 */
@Getter
@AllArgsConstructor
public enum AxfStateEnums {

  /**
   * 先学后付状态
   */
  INIT("初始"),
  AXF_PROCESS("安心付开通中"),
  AXF_SUCCESS("安心付开通成功"),
  AXF_FAIL("安心付开通失败"),
  SETTLE_SUCCESS("结算账户绑定成功"),
  SETTLE_FAIL("结算账户绑定失败"),
  STORE_PROCESS("门店开通中"),
  STORE_SUCCESS("门店开通成功"),
  STORE_FAIL("门店开通失败"),
  ;

  @EnumValue
  private final String code = name();

  private final String message;

}
