package com.jiejing.fitness.finance.api.axf.request;

import com.jiejing.fitness.finance.api.axf.enums.AxfOrderSignStateEnums;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/9/10 14:14
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "分页查询安心付订购单")
public class PageStudioAxfOrderRequest {

  @ApiModelProperty(value = "场馆ID")
  private Long studioId;

  @ApiModelProperty(value = "场馆名称")
  private String studioName;

  @ApiModelProperty(value = "学员ID")
  private Long memberId;

  @ApiModelProperty(value = "学员名称")
  private String memberName;

  @ApiModelProperty(value = "支付宝pid")
  private String merchantNo;

  @ApiModelProperty(value = "订单号")
  private String voucherBusinessNo;

  @ApiModelProperty(value = "支付宝订购单号")
  private String thirdOrderNo;

  @ApiModelProperty(value = "签约开始时间")
  private Date signTimeStart;

  @ApiModelProperty(value = "签约结束时间")
  private Date signTimeEnd;

  @ApiModelProperty(value = "解约开始时间")
  private Date cancelTimeStart;

  @ApiModelProperty(value = "解约结束时间")
  private Date cancelTimeEnd;

  @ApiModelProperty(value = "订购单状态")
  private AxfOrderSignStateEnums state;

  @ApiModelProperty(value = "页码", notes = "1开始")
  private Integer current;

  @ApiModelProperty(value = "分页大小")
  private Integer size = 10;

}
