package com.jiejing.fitness.finance.api.merchant.vo;

import com.jiejing.fitness.finance.api.enums.ApplyTypeEnums;
import com.jiejing.fitness.finance.api.merchant.request.model.BrandBankCardInfo;
import com.jiejing.fitness.finance.api.merchant.request.model.BrandLegalInfo;
import com.jiejing.fitness.finance.api.merchant.request.model.BrandLicenseInfo;
import com.jiejing.fitness.finance.api.merchant.request.model.BrandResourceInfo;
import com.jiejing.paycenter.common.enums.common.OpenStateEnums;
import com.jiejing.paycenter.common.enums.merchant.CompanyTypeEnums;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/2/22 16:22
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "品牌商户申请VO")
public class BrandMerchantApplyVO {

  @ApiModelProperty("ID")
  private Long id;

  @ApiModelProperty("品牌ID")
  private Long brandId;

  @ApiModelProperty("场馆ID")
  private Long studioId;

  @ApiModelProperty("申请单号")
  private String applyNo;

  @ApiModelProperty("申请类型：OPEN-进件；RE_OPEN-重进件；")
  private ApplyTypeEnums applyType;

  @ApiModelProperty("渠道号")
  private String channelNo;

  @ApiModelProperty("商户ID（pay center提供）")
  private Long merchantId;

  @ApiModelProperty("三方商户号")
  private String merchantNo;

  @ApiModelProperty("商户名称")
  private String merchantName;

  @ApiModelProperty("商户简称")
  private String shortName;

  @ApiModelProperty("企业类型")
  private CompanyTypeEnums companyType;

  @ApiModelProperty("开通状态：I-初始态；P-处理中；S-成功；F-失败 默认值: I")
  private OpenStateEnums openState;

  @ApiModelProperty("开通失败原因")
  private String openFailMessage;

  @ApiModelProperty("支付宝开通状态：I-初始态；S-成功；F-失败 默认值: I")
  private OpenStateEnums aliOpenState;

  @ApiModelProperty("支付宝认证状态")
  private OpenStateEnums aliAuthState;

  @ApiModelProperty("支付宝商户号")
  private String aliMerchantNo;

  @ApiModelProperty("支付宝开通失败原因")
  private String aliOpenFailMessage;

  @ApiModelProperty("微信线下通道开通状态：I-初始态；S-成功；F-失败 默认值: I")
  private OpenStateEnums wxOfflineOpenState;

  @ApiModelProperty("微信线下通道认证状态：I-初始态；S-成功；F-失败 默认值: I")
  private OpenStateEnums wxOfflineAuthState;

  @ApiModelProperty("微信线下通道商户号")
  private String wxOfflineMerchantNo;

  @ApiModelProperty("微信线下通道开通失败原因")
  private String wxOfflineOpenFailMessage;

  @ApiModelProperty("微信线上通道开通状态：I-初始态；S-成功；F-失败 默认值: I")
  private OpenStateEnums wxOnlineOpenState;

  @ApiModelProperty("微信线上通道认证状态：I-初始态；S-成功；F-失败 默认值: I")
  private OpenStateEnums wxOnlineAuthState;

  @ApiModelProperty("微信线上通道商户号")
  private String wxOnlineMerchantNo;

  @ApiModelProperty("微信线下通道开通失败原因")
  private String wxOnlineOpenFailMessage;

  @ApiModelProperty(value = "营业执照")
  private BrandLicenseInfo license;

  @ApiModelProperty(value = "法人信息")
  private BrandLegalInfo legal;

  @ApiModelProperty(value = "结算卡信息")
  private BrandBankCardInfo bankCard;

  @ApiModelProperty(value = "进件所需资料")
  private BrandResourceInfo resource;

  @ApiModelProperty("完成时间")
  private Date finishTime;

  @ApiModelProperty("创建时间")
  private Date createTime;

  @ApiModelProperty("更新时间")
  private Date updateTime;

}
