package com.jiejing.fitness.finance.repository.query;

import com.jiejing.paycenter.common.enums.common.TransStateEnums;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 分页查询场馆结算记录参数
 *
 * @author chengyubing
 * @since 2024/4/7 18:03
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class PageStudioSettleQuery {

  /**
   * 场馆名称
   */
  private String studioName;

  /**
   * 场馆ID
   */
  private Long studioId;

  /**
   * 商户号
   */
  private String merchantNo;

  /**
   * 结算状态
   */
  private TransStateEnums transState;

  /**
   * 开始时间
   */
  private Date startTime;

  /**
   * 结束时间
   */
  private Date endTime;

  /**
   * 页码：0开始
   */
  private Integer current;

  /**
   * 分页大小
   */
  private Integer size;

}
