package com.jiejing.fitness.finance.service.pay;

import com.jiejing.fitness.finance.service.pay.params.AppPayParams;
import com.jiejing.fitness.finance.service.pay.params.NativePayParams;
import com.jiejing.fitness.finance.service.pay.params.StudioMerchantPayParams;
import com.jiejing.paycenter.common.enums.common.PayChannelEnums;
import com.jiejing.paycenter.common.model.vo.PayVO;
import com.jiejing.paycenter.common.event.PayEvent;

/**
 * @author chengyubing
 * @since 2024/2/27 11:05
 */
public interface PayService {

  /**
   * 获取openId
   *
   * @param channel  渠道
   * @param appId    appId
   * @param authCode 标记
   * @return openId
   */
  String getOpenId(PayChannelEnums channel, String appId, String authCode);

  /**
   * Native支付
   *
   * @param params 参数
   * @return 结果
   */
  PayVO nativePay(NativePayParams params);

  /**
   * App支付
   *
   * @param params 参数
   * @return 结果
   */
  PayVO appPay(AppPayParams params);

  /**
   * 商户版支付
   *
   * @param params 请求参数
   * @return 结果
   */
  PayVO merchantPay(StudioMerchantPayParams params);

  /**
   * 支付回调
   *
   * @param event 事件
   */
  void payCallback(PayEvent event);

}
