package com.jiejing.fitness.finance.api.bank.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/4/1 14:15
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "分页查询支行")
public class PageBranchBankRequest {

  @ApiModelProperty(value = "银行编码")
  private String bankCode;

  @ApiModelProperty(value = "支行名称")
  private String branchName;

  @ApiModelProperty(value = "页码：0开始", required = true)
  @NotNull(message = "页码不能为空")
  private Integer current;

  @ApiModelProperty(value = "条数", required = true)
  @NotNull(message = "条数不能为空")
  private Integer size;

}
