package com.jiejing.fitness.finance.app.controller.bank;

import com.jiejing.common.model.JsonResult;
import com.jiejing.common.model.PageVO;
import com.jiejing.common.utils.convert.BeanUtil;
import com.jiejing.fitness.finance.api.bank.BankApi;
import com.jiejing.fitness.finance.api.bank.request.PageBankRequest;
import com.jiejing.fitness.finance.api.bank.request.PageBranchBankRequest;
import com.jiejing.fitness.finance.api.bank.vo.BankVO;
import com.jiejing.fitness.finance.api.bank.vo.BranchBankVO;
import com.jiejing.fitness.finance.service.bank.BankService;
import com.jiejing.fitness.finance.service.bank.dto.BankDTO;
import com.jiejing.fitness.finance.service.bank.dto.BranchBankDTO;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author chengyubing
 * @since 2024/4/1 14:45
 */
@RestController
public class BankController implements BankApi {

  @Resource
  private BankService bankService;

  @ApiOperation(value = "分页查询银行列表", tags = TAG)
  @PostMapping(value = "/private/bank/pageBank")
  @Override
  public JsonResult<PageVO<BankVO>> pageBank(@Valid @RequestBody PageBankRequest request) {
    PageVO<BankDTO> page = bankService.pageBank(request.getBankName(), request.getCurrent(),
        request.getSize());
    return JsonResult.success(PageVO.convert(page, BeanUtil.mapList(page.getRecords(), BankVO.class)));
  }

  @ApiOperation(value = "分页查询支行列表", tags = TAG)
  @PostMapping(value = "/private/bank/pageBranchBank")
  @Override
  public JsonResult<PageVO<BranchBankVO>> pageBranchBank(@Valid @RequestBody PageBranchBankRequest request) {
    PageVO<BranchBankDTO> page = bankService.pageBranchBank(request.getBankCode(), request.getBranchName(),
        request.getCurrent(), request.getSize());
    return JsonResult.success(PageVO.convert(page, BeanUtil.mapList(page.getRecords(), BranchBankVO.class)));
  }

}
