package com.jiejing.fitness.finance.app.controller.cashier;

import com.jiejing.common.model.JsonResult;
import com.jiejing.common.model.PageVO;
import com.jiejing.common.utils.convert.BeanUtil;
import com.jiejing.fitness.finance.api.cashier.StudioCashierApi;
import com.jiejing.fitness.finance.api.cashier.request.GetStudioCashierByIdRequest;
import com.jiejing.fitness.finance.api.cashier.request.ListStudioCashierByOrderNoRequest;
import com.jiejing.fitness.finance.api.cashier.request.ListStudioCashierBySubOrderNoRequest;
import com.jiejing.fitness.finance.api.cashier.request.PageStudioCashierRequest;
import com.jiejing.fitness.finance.api.cashier.request.PageStudioSettleRequest;
import com.jiejing.fitness.finance.api.cashier.vo.StudioCashierRecordVO;
import com.jiejing.fitness.finance.api.cashier.vo.StudioCashierStatisticVO;
import com.jiejing.fitness.finance.api.cashier.vo.StudioSettleVO;
import com.jiejing.fitness.finance.service.cashier.StudioCashierService;
import com.jiejing.fitness.finance.service.cashier.params.PageStudioCashierParams;
import com.jiejing.fitness.finance.service.cashier.params.PageStudioSettleParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author chengyubing
 * @since 2024/2/29 10:41
 */
@RestController
public class StudioCashierController implements StudioCashierApi {

  @Resource
  private StudioCashierService studioCashierService;

  @ApiOperation(value = "分页筛选收银流水", tags = {TAG})
  @PostMapping(value = "private/studioCashier/page")
  @Override
  public JsonResult<PageVO<StudioCashierRecordVO>> page(
      @Valid @RequestBody PageStudioCashierRequest request) {
    PageStudioCashierParams params = BeanUtil.map(request, PageStudioCashierParams.class);
    return JsonResult.success(studioCashierService.page(params));
  }

  @ApiOperation(value = "统计收银流水金额", tags = {TAG})
  @PostMapping(value = "/private/studioCashier/statistic")
  @Override
  public JsonResult<StudioCashierStatisticVO> statistic(@Valid @RequestBody PageStudioCashierRequest request) {
    PageStudioCashierParams params = BeanUtil.map(request, PageStudioCashierParams.class);
    return JsonResult.success(studioCashierService.statistic(params));
  }

  @ApiOperation(value = "查询收银流水详情", tags = {TAG})
  @PostMapping(value = "/private/studioCashier/getById")
  @Override
  public JsonResult<StudioCashierRecordVO> getById(@Valid @RequestBody GetStudioCashierByIdRequest request) {
    return JsonResult.success(studioCashierService.getById(request.getId()));
  }

  @ApiOperation(value = "根据订单号查询收银列表", tags = {TAG})
  @PostMapping(value = "/private/studioCashier/listByOrderNo")
  @Override
  public JsonResult<List<StudioCashierRecordVO>> listByOrderNo(
      @Valid @RequestBody ListStudioCashierByOrderNoRequest request) {
    return JsonResult.success(studioCashierService.listByOrderNo(request.getOrderNo()));
  }

  @ApiOperation(value = "根据子订单号查询收银列表", tags = {TAG})
  @PostMapping(value = "/private/studioCashier/listBySubOrderNo")
  @Override
  public JsonResult<List<StudioCashierRecordVO>> listBySubOrderNo(
      @Valid @RequestBody ListStudioCashierBySubOrderNoRequest request) {
    return JsonResult.success(studioCashierService.listBySubOrderNo(request.getSubOrderNo()));
  }

  @ApiOperation(value = "分页筛选结算记录", tags = {TAG})
  @PostMapping(value = "/private/studioCashier/pageSettle")
  @Override
  public JsonResult<PageVO<StudioSettleVO>> pageSettle(@Valid @RequestBody PageStudioSettleRequest request) {
    PageStudioSettleParams params = BeanUtil.map(request, PageStudioSettleParams.class);
    return JsonResult.success(studioCashierService.page(params));
  }

}
